<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientMembership StructType
 * @subpackage Structs
 */
class ClientMembership extends ClientService
{
    /**
     * The RestrictedLocations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLocation
     */
    public $RestrictedLocations;
    /**
     * The IconCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IconCode;
    /**
     * Constructor method for ClientMembership
     * @uses ClientMembership::setRestrictedLocations()
     * @uses ClientMembership::setIconCode()
     * @param \ArrayType\ArrayOfLocation $restrictedLocations
     * @param string $iconCode
     */
    public function __construct(\ArrayType\ArrayOfLocation $restrictedLocations = null, $iconCode = null)
    {
        $this
            ->setRestrictedLocations($restrictedLocations)
            ->setIconCode($iconCode);
    }
    /**
     * Get RestrictedLocations value
     * @return \ArrayType\ArrayOfLocation|null
     */
    public function getRestrictedLocations()
    {
        return $this->RestrictedLocations;
    }
    /**
     * Set RestrictedLocations value
     * @param \ArrayType\ArrayOfLocation $restrictedLocations
     * @return \StructType\ClientMembership
     */
    public function setRestrictedLocations(\ArrayType\ArrayOfLocation $restrictedLocations = null)
    {
        $this->RestrictedLocations = $restrictedLocations;
        return $this;
    }
    /**
     * Get IconCode value
     * @return string|null
     */
    public function getIconCode()
    {
        return $this->IconCode;
    }
    /**
     * Set IconCode value
     * @param string $iconCode
     * @return \StructType\ClientMembership
     */
    public function setIconCode($iconCode = null)
    {
        // validation for constraint: string
        if (!is_null($iconCode) && !is_string($iconCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iconCode)), __LINE__);
        }
        $this->IconCode = $iconCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClientMembership
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
