<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Client StructType
 * @subpackage Structs
 */
class Client extends MBObject
{
    /**
     * The NewID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewID;
    /**
     * The AccountBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $AccountBalance;
    /**
     * The ClientIndexes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfClientIndex
     */
    public $ClientIndexes;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The MobileProvider
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MobileProvider;
    /**
     * The ClientCreditCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ClientCreditCard
     */
    public $ClientCreditCard;
    /**
     * The LastFormulaNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastFormulaNotes;
    /**
     * The AppointmentGenderPreference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AppointmentGenderPreference;
    /**
     * The Gender
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Gender;
    /**
     * The IsCompany
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCompany;
    /**
     * The Inactive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Inactive;
    /**
     * The ClientRelationships
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfClientRelationship
     */
    public $ClientRelationships;
    /**
     * The Reps
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRep
     */
    public $Reps;
    /**
     * The SaleReps
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSalesRep
     */
    public $SaleReps;
    /**
     * The CustomClientFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCustomClientField
     */
    public $CustomClientFields;
    /**
     * The LiabilityRelease
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $LiabilityRelease;
    /**
     * The EmergencyContactInfoName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmergencyContactInfoName;
    /**
     * The EmergencyContactInfoRelationship
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmergencyContactInfoRelationship;
    /**
     * The EmergencyContactInfoPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmergencyContactInfoPhone;
    /**
     * The EmergencyContactInfoEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmergencyContactInfoEmail;
    /**
     * The PromotionalEmailOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PromotionalEmailOptIn;
    /**
     * The CreationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The Liability
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Liability
     */
    public $Liability;
    /**
     * The ProspectStage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProspectStage
     */
    public $ProspectStage;
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $UniqueID;
    /**
     * The MembershipIcon
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $MembershipIcon;
    /**
     * The SiteId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SiteId;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiddleName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The EmailOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EmailOptIn;
    /**
     * The AddressLine1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine2;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The MobilePhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MobilePhone;
    /**
     * The HomePhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HomePhone;
    /**
     * The WorkPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkPhone;
    /**
     * The WorkExtension
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkExtension;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BirthDate;
    /**
     * The FirstAppointmentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstAppointmentDate;
    /**
     * The ReferredBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferredBy;
    /**
     * The HomeLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Location
     */
    public $HomeLocation;
    /**
     * The YellowAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $YellowAlert;
    /**
     * The RedAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RedAlert;
    /**
     * The PhotoURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhotoURL;
    /**
     * The IsProspect
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsProspect;
    /**
     * The LastModifiedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastModifiedDateTime;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The ContactMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ContactMethod;
    /**
     * Constructor method for Client
     * @uses Client::setNewID()
     * @uses Client::setAccountBalance()
     * @uses Client::setClientIndexes()
     * @uses Client::setUsername()
     * @uses Client::setPassword()
     * @uses Client::setNotes()
     * @uses Client::setMobileProvider()
     * @uses Client::setClientCreditCard()
     * @uses Client::setLastFormulaNotes()
     * @uses Client::setAppointmentGenderPreference()
     * @uses Client::setGender()
     * @uses Client::setIsCompany()
     * @uses Client::setInactive()
     * @uses Client::setClientRelationships()
     * @uses Client::setReps()
     * @uses Client::setSaleReps()
     * @uses Client::setCustomClientFields()
     * @uses Client::setLiabilityRelease()
     * @uses Client::setEmergencyContactInfoName()
     * @uses Client::setEmergencyContactInfoRelationship()
     * @uses Client::setEmergencyContactInfoPhone()
     * @uses Client::setEmergencyContactInfoEmail()
     * @uses Client::setPromotionalEmailOptIn()
     * @uses Client::setCreationDate()
     * @uses Client::setLiability()
     * @uses Client::setProspectStage()
     * @uses Client::setUniqueID()
     * @uses Client::setMembershipIcon()
     * @uses Client::setSiteId()
     * @uses Client::setAction()
     * @uses Client::setID()
     * @uses Client::setFirstName()
     * @uses Client::setMiddleName()
     * @uses Client::setLastName()
     * @uses Client::setEmail()
     * @uses Client::setEmailOptIn()
     * @uses Client::setAddressLine1()
     * @uses Client::setAddressLine2()
     * @uses Client::setCity()
     * @uses Client::setState()
     * @uses Client::setPostalCode()
     * @uses Client::setCountry()
     * @uses Client::setMobilePhone()
     * @uses Client::setHomePhone()
     * @uses Client::setWorkPhone()
     * @uses Client::setWorkExtension()
     * @uses Client::setBirthDate()
     * @uses Client::setFirstAppointmentDate()
     * @uses Client::setReferredBy()
     * @uses Client::setHomeLocation()
     * @uses Client::setYellowAlert()
     * @uses Client::setRedAlert()
     * @uses Client::setPhotoURL()
     * @uses Client::setIsProspect()
     * @uses Client::setLastModifiedDateTime()
     * @uses Client::setStatus()
     * @uses Client::setContactMethod()
     * @param string $newID
     * @param float $accountBalance
     * @param \ArrayType\ArrayOfClientIndex $clientIndexes
     * @param string $username
     * @param string $password
     * @param string $notes
     * @param int $mobileProvider
     * @param \StructType\ClientCreditCard $clientCreditCard
     * @param string $lastFormulaNotes
     * @param string $appointmentGenderPreference
     * @param string $gender
     * @param bool $isCompany
     * @param bool $inactive
     * @param \ArrayType\ArrayOfClientRelationship $clientRelationships
     * @param \ArrayType\ArrayOfRep $reps
     * @param \ArrayType\ArrayOfSalesRep $saleReps
     * @param \ArrayType\ArrayOfCustomClientField $customClientFields
     * @param bool $liabilityRelease
     * @param string $emergencyContactInfoName
     * @param string $emergencyContactInfoRelationship
     * @param string $emergencyContactInfoPhone
     * @param string $emergencyContactInfoEmail
     * @param bool $promotionalEmailOptIn
     * @param string $creationDate
     * @param \StructType\Liability $liability
     * @param \StructType\ProspectStage $prospectStage
     * @param int $uniqueID
     * @param int $membershipIcon
     * @param int $siteId
     * @param string $action
     * @param string $iD
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     * @param string $email
     * @param bool $emailOptIn
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $city
     * @param string $state
     * @param string $postalCode
     * @param string $country
     * @param string $mobilePhone
     * @param string $homePhone
     * @param string $workPhone
     * @param string $workExtension
     * @param string $birthDate
     * @param string $firstAppointmentDate
     * @param string $referredBy
     * @param \StructType\Location $homeLocation
     * @param string $yellowAlert
     * @param string $redAlert
     * @param string $photoURL
     * @param bool $isProspect
     * @param string $lastModifiedDateTime
     * @param string $status
     * @param int $contactMethod
     */
    public function __construct($newID = null, $accountBalance = null, \ArrayType\ArrayOfClientIndex $clientIndexes = null, $username = null, $password = null, $notes = null, $mobileProvider = null, \StructType\ClientCreditCard $clientCreditCard = null, $lastFormulaNotes = null, $appointmentGenderPreference = null, $gender = null, $isCompany = null, $inactive = null, \ArrayType\ArrayOfClientRelationship $clientRelationships = null, \ArrayType\ArrayOfRep $reps = null, \ArrayType\ArrayOfSalesRep $saleReps = null, \ArrayType\ArrayOfCustomClientField $customClientFields = null, $liabilityRelease = null, $emergencyContactInfoName = null, $emergencyContactInfoRelationship = null, $emergencyContactInfoPhone = null, $emergencyContactInfoEmail = null, $promotionalEmailOptIn = null, $creationDate = null, \StructType\Liability $liability = null, \StructType\ProspectStage $prospectStage = null, $uniqueID = null, $membershipIcon = null, $siteId = null, $action = null, $iD = null, $firstName = null, $middleName = null, $lastName = null, $email = null, $emailOptIn = null, $addressLine1 = null, $addressLine2 = null, $city = null, $state = null, $postalCode = null, $country = null, $mobilePhone = null, $homePhone = null, $workPhone = null, $workExtension = null, $birthDate = null, $firstAppointmentDate = null, $referredBy = null, \StructType\Location $homeLocation = null, $yellowAlert = null, $redAlert = null, $photoURL = null, $isProspect = null, $lastModifiedDateTime = null, $status = null, $contactMethod = null)
    {
        $this
            ->setNewID($newID)
            ->setAccountBalance($accountBalance)
            ->setClientIndexes($clientIndexes)
            ->setUsername($username)
            ->setPassword($password)
            ->setNotes($notes)
            ->setMobileProvider($mobileProvider)
            ->setClientCreditCard($clientCreditCard)
            ->setLastFormulaNotes($lastFormulaNotes)
            ->setAppointmentGenderPreference($appointmentGenderPreference)
            ->setGender($gender)
            ->setIsCompany($isCompany)
            ->setInactive($inactive)
            ->setClientRelationships($clientRelationships)
            ->setReps($reps)
            ->setSaleReps($saleReps)
            ->setCustomClientFields($customClientFields)
            ->setLiabilityRelease($liabilityRelease)
            ->setEmergencyContactInfoName($emergencyContactInfoName)
            ->setEmergencyContactInfoRelationship($emergencyContactInfoRelationship)
            ->setEmergencyContactInfoPhone($emergencyContactInfoPhone)
            ->setEmergencyContactInfoEmail($emergencyContactInfoEmail)
            ->setPromotionalEmailOptIn($promotionalEmailOptIn)
            ->setCreationDate($creationDate)
            ->setLiability($liability)
            ->setProspectStage($prospectStage)
            ->setUniqueID($uniqueID)
            ->setMembershipIcon($membershipIcon)
            ->setSiteId($siteId)
            ->setAction($action)
            ->setID($iD)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName)
            ->setEmail($email)
            ->setEmailOptIn($emailOptIn)
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setCity($city)
            ->setState($state)
            ->setPostalCode($postalCode)
            ->setCountry($country)
            ->setMobilePhone($mobilePhone)
            ->setHomePhone($homePhone)
            ->setWorkPhone($workPhone)
            ->setWorkExtension($workExtension)
            ->setBirthDate($birthDate)
            ->setFirstAppointmentDate($firstAppointmentDate)
            ->setReferredBy($referredBy)
            ->setHomeLocation($homeLocation)
            ->setYellowAlert($yellowAlert)
            ->setRedAlert($redAlert)
            ->setPhotoURL($photoURL)
            ->setIsProspect($isProspect)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setStatus($status)
            ->setContactMethod($contactMethod);
    }
    /**
     * Get NewID value
     * @return string|null
     */
    public function getNewID()
    {
        return $this->NewID;
    }
    /**
     * Set NewID value
     * @param string $newID
     * @return \StructType\Client
     */
    public function setNewID($newID = null)
    {
        // validation for constraint: string
        if (!is_null($newID) && !is_string($newID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newID)), __LINE__);
        }
        $this->NewID = $newID;
        return $this;
    }
    /**
     * Get AccountBalance value
     * @return float|null
     */
    public function getAccountBalance()
    {
        return $this->AccountBalance;
    }
    /**
     * Set AccountBalance value
     * @param float $accountBalance
     * @return \StructType\Client
     */
    public function setAccountBalance($accountBalance = null)
    {
        $this->AccountBalance = $accountBalance;
        return $this;
    }
    /**
     * Get ClientIndexes value
     * @return \ArrayType\ArrayOfClientIndex|null
     */
    public function getClientIndexes()
    {
        return $this->ClientIndexes;
    }
    /**
     * Set ClientIndexes value
     * @param \ArrayType\ArrayOfClientIndex $clientIndexes
     * @return \StructType\Client
     */
    public function setClientIndexes(\ArrayType\ArrayOfClientIndex $clientIndexes = null)
    {
        $this->ClientIndexes = $clientIndexes;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\Client
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\Client
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\Client
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get MobileProvider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMobileProvider()
    {
        return isset($this->MobileProvider) ? $this->MobileProvider : null;
    }
    /**
     * Set MobileProvider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mobileProvider
     * @return \StructType\Client
     */
    public function setMobileProvider($mobileProvider = null)
    {
        // validation for constraint: int
        if (!is_null($mobileProvider) && !is_numeric($mobileProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mobileProvider)), __LINE__);
        }
        if (is_null($mobileProvider) || (is_array($mobileProvider) && empty($mobileProvider))) {
            unset($this->MobileProvider);
        } else {
            $this->MobileProvider = $mobileProvider;
        }
        return $this;
    }
    /**
     * Get ClientCreditCard value
     * @return \StructType\ClientCreditCard|null
     */
    public function getClientCreditCard()
    {
        return $this->ClientCreditCard;
    }
    /**
     * Set ClientCreditCard value
     * @param \StructType\ClientCreditCard $clientCreditCard
     * @return \StructType\Client
     */
    public function setClientCreditCard(\StructType\ClientCreditCard $clientCreditCard = null)
    {
        $this->ClientCreditCard = $clientCreditCard;
        return $this;
    }
    /**
     * Get LastFormulaNotes value
     * @return string|null
     */
    public function getLastFormulaNotes()
    {
        return $this->LastFormulaNotes;
    }
    /**
     * Set LastFormulaNotes value
     * @param string $lastFormulaNotes
     * @return \StructType\Client
     */
    public function setLastFormulaNotes($lastFormulaNotes = null)
    {
        // validation for constraint: string
        if (!is_null($lastFormulaNotes) && !is_string($lastFormulaNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastFormulaNotes)), __LINE__);
        }
        $this->LastFormulaNotes = $lastFormulaNotes;
        return $this;
    }
    /**
     * Get AppointmentGenderPreference value
     * @return string|null
     */
    public function getAppointmentGenderPreference()
    {
        return $this->AppointmentGenderPreference;
    }
    /**
     * Set AppointmentGenderPreference value
     * @param string $appointmentGenderPreference
     * @return \StructType\Client
     */
    public function setAppointmentGenderPreference($appointmentGenderPreference = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentGenderPreference) && !is_string($appointmentGenderPreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appointmentGenderPreference)), __LINE__);
        }
        $this->AppointmentGenderPreference = $appointmentGenderPreference;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \StructType\Client
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get IsCompany value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCompany()
    {
        return isset($this->IsCompany) ? $this->IsCompany : null;
    }
    /**
     * Set IsCompany value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCompany
     * @return \StructType\Client
     */
    public function setIsCompany($isCompany = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCompany) && !is_bool($isCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCompany)), __LINE__);
        }
        if (is_null($isCompany) || (is_array($isCompany) && empty($isCompany))) {
            unset($this->IsCompany);
        } else {
            $this->IsCompany = $isCompany;
        }
        return $this;
    }
    /**
     * Get Inactive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInactive()
    {
        return isset($this->Inactive) ? $this->Inactive : null;
    }
    /**
     * Set Inactive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inactive
     * @return \StructType\Client
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inactive)), __LINE__);
        }
        if (is_null($inactive) || (is_array($inactive) && empty($inactive))) {
            unset($this->Inactive);
        } else {
            $this->Inactive = $inactive;
        }
        return $this;
    }
    /**
     * Get ClientRelationships value
     * @return \ArrayType\ArrayOfClientRelationship|null
     */
    public function getClientRelationships()
    {
        return $this->ClientRelationships;
    }
    /**
     * Set ClientRelationships value
     * @param \ArrayType\ArrayOfClientRelationship $clientRelationships
     * @return \StructType\Client
     */
    public function setClientRelationships(\ArrayType\ArrayOfClientRelationship $clientRelationships = null)
    {
        $this->ClientRelationships = $clientRelationships;
        return $this;
    }
    /**
     * Get Reps value
     * @return \ArrayType\ArrayOfRep|null
     */
    public function getReps()
    {
        return $this->Reps;
    }
    /**
     * Set Reps value
     * @param \ArrayType\ArrayOfRep $reps
     * @return \StructType\Client
     */
    public function setReps(\ArrayType\ArrayOfRep $reps = null)
    {
        $this->Reps = $reps;
        return $this;
    }
    /**
     * Get SaleReps value
     * @return \ArrayType\ArrayOfSalesRep|null
     */
    public function getSaleReps()
    {
        return $this->SaleReps;
    }
    /**
     * Set SaleReps value
     * @param \ArrayType\ArrayOfSalesRep $saleReps
     * @return \StructType\Client
     */
    public function setSaleReps(\ArrayType\ArrayOfSalesRep $saleReps = null)
    {
        $this->SaleReps = $saleReps;
        return $this;
    }
    /**
     * Get CustomClientFields value
     * @return \ArrayType\ArrayOfCustomClientField|null
     */
    public function getCustomClientFields()
    {
        return $this->CustomClientFields;
    }
    /**
     * Set CustomClientFields value
     * @param \ArrayType\ArrayOfCustomClientField $customClientFields
     * @return \StructType\Client
     */
    public function setCustomClientFields(\ArrayType\ArrayOfCustomClientField $customClientFields = null)
    {
        $this->CustomClientFields = $customClientFields;
        return $this;
    }
    /**
     * Get LiabilityRelease value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLiabilityRelease()
    {
        return isset($this->LiabilityRelease) ? $this->LiabilityRelease : null;
    }
    /**
     * Set LiabilityRelease value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $liabilityRelease
     * @return \StructType\Client
     */
    public function setLiabilityRelease($liabilityRelease = null)
    {
        // validation for constraint: boolean
        if (!is_null($liabilityRelease) && !is_bool($liabilityRelease)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($liabilityRelease)), __LINE__);
        }
        if (is_null($liabilityRelease) || (is_array($liabilityRelease) && empty($liabilityRelease))) {
            unset($this->LiabilityRelease);
        } else {
            $this->LiabilityRelease = $liabilityRelease;
        }
        return $this;
    }
    /**
     * Get EmergencyContactInfoName value
     * @return string|null
     */
    public function getEmergencyContactInfoName()
    {
        return $this->EmergencyContactInfoName;
    }
    /**
     * Set EmergencyContactInfoName value
     * @param string $emergencyContactInfoName
     * @return \StructType\Client
     */
    public function setEmergencyContactInfoName($emergencyContactInfoName = null)
    {
        // validation for constraint: string
        if (!is_null($emergencyContactInfoName) && !is_string($emergencyContactInfoName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emergencyContactInfoName)), __LINE__);
        }
        $this->EmergencyContactInfoName = $emergencyContactInfoName;
        return $this;
    }
    /**
     * Get EmergencyContactInfoRelationship value
     * @return string|null
     */
    public function getEmergencyContactInfoRelationship()
    {
        return $this->EmergencyContactInfoRelationship;
    }
    /**
     * Set EmergencyContactInfoRelationship value
     * @param string $emergencyContactInfoRelationship
     * @return \StructType\Client
     */
    public function setEmergencyContactInfoRelationship($emergencyContactInfoRelationship = null)
    {
        // validation for constraint: string
        if (!is_null($emergencyContactInfoRelationship) && !is_string($emergencyContactInfoRelationship)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emergencyContactInfoRelationship)), __LINE__);
        }
        $this->EmergencyContactInfoRelationship = $emergencyContactInfoRelationship;
        return $this;
    }
    /**
     * Get EmergencyContactInfoPhone value
     * @return string|null
     */
    public function getEmergencyContactInfoPhone()
    {
        return $this->EmergencyContactInfoPhone;
    }
    /**
     * Set EmergencyContactInfoPhone value
     * @param string $emergencyContactInfoPhone
     * @return \StructType\Client
     */
    public function setEmergencyContactInfoPhone($emergencyContactInfoPhone = null)
    {
        // validation for constraint: string
        if (!is_null($emergencyContactInfoPhone) && !is_string($emergencyContactInfoPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emergencyContactInfoPhone)), __LINE__);
        }
        $this->EmergencyContactInfoPhone = $emergencyContactInfoPhone;
        return $this;
    }
    /**
     * Get EmergencyContactInfoEmail value
     * @return string|null
     */
    public function getEmergencyContactInfoEmail()
    {
        return $this->EmergencyContactInfoEmail;
    }
    /**
     * Set EmergencyContactInfoEmail value
     * @param string $emergencyContactInfoEmail
     * @return \StructType\Client
     */
    public function setEmergencyContactInfoEmail($emergencyContactInfoEmail = null)
    {
        // validation for constraint: string
        if (!is_null($emergencyContactInfoEmail) && !is_string($emergencyContactInfoEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emergencyContactInfoEmail)), __LINE__);
        }
        $this->EmergencyContactInfoEmail = $emergencyContactInfoEmail;
        return $this;
    }
    /**
     * Get PromotionalEmailOptIn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPromotionalEmailOptIn()
    {
        return isset($this->PromotionalEmailOptIn) ? $this->PromotionalEmailOptIn : null;
    }
    /**
     * Set PromotionalEmailOptIn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $promotionalEmailOptIn
     * @return \StructType\Client
     */
    public function setPromotionalEmailOptIn($promotionalEmailOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($promotionalEmailOptIn) && !is_bool($promotionalEmailOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($promotionalEmailOptIn)), __LINE__);
        }
        if (is_null($promotionalEmailOptIn) || (is_array($promotionalEmailOptIn) && empty($promotionalEmailOptIn))) {
            unset($this->PromotionalEmailOptIn);
        } else {
            $this->PromotionalEmailOptIn = $promotionalEmailOptIn;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \StructType\Client
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get Liability value
     * @return \StructType\Liability|null
     */
    public function getLiability()
    {
        return $this->Liability;
    }
    /**
     * Set Liability value
     * @param \StructType\Liability $liability
     * @return \StructType\Client
     */
    public function setLiability(\StructType\Liability $liability = null)
    {
        $this->Liability = $liability;
        return $this;
    }
    /**
     * Get ProspectStage value
     * @return \StructType\ProspectStage|null
     */
    public function getProspectStage()
    {
        return $this->ProspectStage;
    }
    /**
     * Set ProspectStage value
     * @param \StructType\ProspectStage $prospectStage
     * @return \StructType\Client
     */
    public function setProspectStage(\StructType\ProspectStage $prospectStage = null)
    {
        $this->ProspectStage = $prospectStage;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return int|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param int $uniqueID
     * @return \StructType\Client
     */
    public function setUniqueID($uniqueID = null)
    {
        // validation for constraint: int
        if (!is_null($uniqueID) && !is_numeric($uniqueID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uniqueID)), __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get MembershipIcon value
     * @return int|null
     */
    public function getMembershipIcon()
    {
        return $this->MembershipIcon;
    }
    /**
     * Set MembershipIcon value
     * @param int $membershipIcon
     * @return \StructType\Client
     */
    public function setMembershipIcon($membershipIcon = null)
    {
        // validation for constraint: int
        if (!is_null($membershipIcon) && !is_numeric($membershipIcon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($membershipIcon)), __LINE__);
        }
        $this->MembershipIcon = $membershipIcon;
        return $this;
    }
    /**
     * Get SiteId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSiteId()
    {
        return isset($this->SiteId) ? $this->SiteId : null;
    }
    /**
     * Set SiteId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $siteId
     * @return \StructType\Client
     */
    public function setSiteId($siteId = null)
    {
        // validation for constraint: int
        if (!is_null($siteId) && !is_numeric($siteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($siteId)), __LINE__);
        }
        if (is_null($siteId) || (is_array($siteId) && empty($siteId))) {
            unset($this->SiteId);
        } else {
            $this->SiteId = $siteId;
        }
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\ActionCode::valueIsValid()
     * @uses \EnumType\ActionCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\Client
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionCode::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\ActionCode::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Client
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\Client
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\Client
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\Client
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Client
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get EmailOptIn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEmailOptIn()
    {
        return isset($this->EmailOptIn) ? $this->EmailOptIn : null;
    }
    /**
     * Set EmailOptIn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $emailOptIn
     * @return \StructType\Client
     */
    public function setEmailOptIn($emailOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailOptIn) && !is_bool($emailOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($emailOptIn)), __LINE__);
        }
        if (is_null($emailOptIn) || (is_array($emailOptIn) && empty($emailOptIn))) {
            unset($this->EmailOptIn);
        } else {
            $this->EmailOptIn = $emailOptIn;
        }
        return $this;
    }
    /**
     * Get AddressLine1 value
     * @return string|null
     */
    public function getAddressLine1()
    {
        return $this->AddressLine1;
    }
    /**
     * Set AddressLine1 value
     * @param string $addressLine1
     * @return \StructType\Client
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine1)), __LINE__);
        }
        $this->AddressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get AddressLine2 value
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->AddressLine2;
    }
    /**
     * Set AddressLine2 value
     * @param string $addressLine2
     * @return \StructType\Client
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine2)), __LINE__);
        }
        $this->AddressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\Client
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\Client
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\Client
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\Client
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get MobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->MobilePhone;
    }
    /**
     * Set MobilePhone value
     * @param string $mobilePhone
     * @return \StructType\Client
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobilePhone)), __LINE__);
        }
        $this->MobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Get HomePhone value
     * @return string|null
     */
    public function getHomePhone()
    {
        return $this->HomePhone;
    }
    /**
     * Set HomePhone value
     * @param string $homePhone
     * @return \StructType\Client
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homePhone)), __LINE__);
        }
        $this->HomePhone = $homePhone;
        return $this;
    }
    /**
     * Get WorkPhone value
     * @return string|null
     */
    public function getWorkPhone()
    {
        return $this->WorkPhone;
    }
    /**
     * Set WorkPhone value
     * @param string $workPhone
     * @return \StructType\Client
     */
    public function setWorkPhone($workPhone = null)
    {
        // validation for constraint: string
        if (!is_null($workPhone) && !is_string($workPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workPhone)), __LINE__);
        }
        $this->WorkPhone = $workPhone;
        return $this;
    }
    /**
     * Get WorkExtension value
     * @return string|null
     */
    public function getWorkExtension()
    {
        return $this->WorkExtension;
    }
    /**
     * Set WorkExtension value
     * @param string $workExtension
     * @return \StructType\Client
     */
    public function setWorkExtension($workExtension = null)
    {
        // validation for constraint: string
        if (!is_null($workExtension) && !is_string($workExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workExtension)), __LINE__);
        }
        $this->WorkExtension = $workExtension;
        return $this;
    }
    /**
     * Get BirthDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBirthDate()
    {
        return isset($this->BirthDate) ? $this->BirthDate : null;
    }
    /**
     * Set BirthDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $birthDate
     * @return \StructType\Client
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        if (is_null($birthDate) || (is_array($birthDate) && empty($birthDate))) {
            unset($this->BirthDate);
        } else {
            $this->BirthDate = $birthDate;
        }
        return $this;
    }
    /**
     * Get FirstAppointmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstAppointmentDate()
    {
        return isset($this->FirstAppointmentDate) ? $this->FirstAppointmentDate : null;
    }
    /**
     * Set FirstAppointmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstAppointmentDate
     * @return \StructType\Client
     */
    public function setFirstAppointmentDate($firstAppointmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstAppointmentDate) && !is_string($firstAppointmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstAppointmentDate)), __LINE__);
        }
        if (is_null($firstAppointmentDate) || (is_array($firstAppointmentDate) && empty($firstAppointmentDate))) {
            unset($this->FirstAppointmentDate);
        } else {
            $this->FirstAppointmentDate = $firstAppointmentDate;
        }
        return $this;
    }
    /**
     * Get ReferredBy value
     * @return string|null
     */
    public function getReferredBy()
    {
        return $this->ReferredBy;
    }
    /**
     * Set ReferredBy value
     * @param string $referredBy
     * @return \StructType\Client
     */
    public function setReferredBy($referredBy = null)
    {
        // validation for constraint: string
        if (!is_null($referredBy) && !is_string($referredBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referredBy)), __LINE__);
        }
        $this->ReferredBy = $referredBy;
        return $this;
    }
    /**
     * Get HomeLocation value
     * @return \StructType\Location|null
     */
    public function getHomeLocation()
    {
        return $this->HomeLocation;
    }
    /**
     * Set HomeLocation value
     * @param \StructType\Location $homeLocation
     * @return \StructType\Client
     */
    public function setHomeLocation(\StructType\Location $homeLocation = null)
    {
        $this->HomeLocation = $homeLocation;
        return $this;
    }
    /**
     * Get YellowAlert value
     * @return string|null
     */
    public function getYellowAlert()
    {
        return $this->YellowAlert;
    }
    /**
     * Set YellowAlert value
     * @param string $yellowAlert
     * @return \StructType\Client
     */
    public function setYellowAlert($yellowAlert = null)
    {
        // validation for constraint: string
        if (!is_null($yellowAlert) && !is_string($yellowAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($yellowAlert)), __LINE__);
        }
        $this->YellowAlert = $yellowAlert;
        return $this;
    }
    /**
     * Get RedAlert value
     * @return string|null
     */
    public function getRedAlert()
    {
        return $this->RedAlert;
    }
    /**
     * Set RedAlert value
     * @param string $redAlert
     * @return \StructType\Client
     */
    public function setRedAlert($redAlert = null)
    {
        // validation for constraint: string
        if (!is_null($redAlert) && !is_string($redAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redAlert)), __LINE__);
        }
        $this->RedAlert = $redAlert;
        return $this;
    }
    /**
     * Get PhotoURL value
     * @return string|null
     */
    public function getPhotoURL()
    {
        return $this->PhotoURL;
    }
    /**
     * Set PhotoURL value
     * @param string $photoURL
     * @return \StructType\Client
     */
    public function setPhotoURL($photoURL = null)
    {
        // validation for constraint: string
        if (!is_null($photoURL) && !is_string($photoURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($photoURL)), __LINE__);
        }
        $this->PhotoURL = $photoURL;
        return $this;
    }
    /**
     * Get IsProspect value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsProspect()
    {
        return isset($this->IsProspect) ? $this->IsProspect : null;
    }
    /**
     * Set IsProspect value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isProspect
     * @return \StructType\Client
     */
    public function setIsProspect($isProspect = null)
    {
        // validation for constraint: boolean
        if (!is_null($isProspect) && !is_bool($isProspect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isProspect)), __LINE__);
        }
        if (is_null($isProspect) || (is_array($isProspect) && empty($isProspect))) {
            unset($this->IsProspect);
        } else {
            $this->IsProspect = $isProspect;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * @return string|null
     */
    public function getLastModifiedDateTime()
    {
        return $this->LastModifiedDateTime;
    }
    /**
     * Set LastModifiedDateTime value
     * @param string $lastModifiedDateTime
     * @return \StructType\Client
     */
    public function setLastModifiedDateTime($lastModifiedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDateTime) && !is_string($lastModifiedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModifiedDateTime)), __LINE__);
        }
        $this->LastModifiedDateTime = $lastModifiedDateTime;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\Client
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ContactMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getContactMethod()
    {
        return isset($this->ContactMethod) ? $this->ContactMethod : null;
    }
    /**
     * Set ContactMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $contactMethod
     * @return \StructType\Client
     */
    public function setContactMethod($contactMethod = null)
    {
        // validation for constraint: int
        if (!is_null($contactMethod) && !is_numeric($contactMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contactMethod)), __LINE__);
        }
        if (is_null($contactMethod) || (is_array($contactMethod) && empty($contactMethod))) {
            unset($this->ContactMethod);
        } else {
            $this->ContactMethod = $contactMethod;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Client
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
