<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Appointment StructType
 * @subpackage Structs
 */
class Appointment extends ScheduleItem
{
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Duration;
    /**
     * The GenderPreference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GenderPreference;
    /**
     * The ProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProviderID;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ID;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The StartDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDateTime;
    /**
     * The EndDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDateTime;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The StaffRequested
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $StaffRequested;
    /**
     * The Program
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Program
     */
    public $Program;
    /**
     * The SessionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SessionType
     */
    public $SessionType;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Location
     */
    public $Location;
    /**
     * The Staff
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Staff
     */
    public $Staff;
    /**
     * The Client
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Client
     */
    public $Client;
    /**
     * The FirstAppointment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $FirstAppointment;
    /**
     * The ClientService
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ClientService
     */
    public $ClientService;
    /**
     * The Resources
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfResource
     */
    public $Resources;
    /**
     * Constructor method for Appointment
     * @uses Appointment::setDuration()
     * @uses Appointment::setGenderPreference()
     * @uses Appointment::setProviderID()
     * @uses Appointment::setAction()
     * @uses Appointment::setID()
     * @uses Appointment::setStatus()
     * @uses Appointment::setStartDateTime()
     * @uses Appointment::setEndDateTime()
     * @uses Appointment::setNotes()
     * @uses Appointment::setStaffRequested()
     * @uses Appointment::setProgram()
     * @uses Appointment::setSessionType()
     * @uses Appointment::setLocation()
     * @uses Appointment::setStaff()
     * @uses Appointment::setClient()
     * @uses Appointment::setFirstAppointment()
     * @uses Appointment::setClientService()
     * @uses Appointment::setResources()
     * @param int $duration
     * @param string $genderPreference
     * @param string $providerID
     * @param string $action
     * @param int $iD
     * @param string $status
     * @param string $startDateTime
     * @param string $endDateTime
     * @param string $notes
     * @param bool $staffRequested
     * @param \StructType\Program $program
     * @param \StructType\SessionType $sessionType
     * @param \StructType\Location $location
     * @param \StructType\Staff $staff
     * @param \StructType\Client $client
     * @param bool $firstAppointment
     * @param \StructType\ClientService $clientService
     * @param \ArrayType\ArrayOfResource $resources
     */
    public function __construct($duration = null, $genderPreference = null, $providerID = null, $action = null, $iD = null, $status = null, $startDateTime = null, $endDateTime = null, $notes = null, $staffRequested = null, \StructType\Program $program = null, \StructType\SessionType $sessionType = null, \StructType\Location $location = null, \StructType\Staff $staff = null, \StructType\Client $client = null, $firstAppointment = null, \StructType\ClientService $clientService = null, \ArrayType\ArrayOfResource $resources = null)
    {
        $this
            ->setDuration($duration)
            ->setGenderPreference($genderPreference)
            ->setProviderID($providerID)
            ->setAction($action)
            ->setID($iD)
            ->setStatus($status)
            ->setStartDateTime($startDateTime)
            ->setEndDateTime($endDateTime)
            ->setNotes($notes)
            ->setStaffRequested($staffRequested)
            ->setProgram($program)
            ->setSessionType($sessionType)
            ->setLocation($location)
            ->setStaff($staff)
            ->setClient($client)
            ->setFirstAppointment($firstAppointment)
            ->setClientService($clientService)
            ->setResources($resources);
    }
    /**
     * Get Duration value
     * @return int
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\Appointment
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !is_numeric($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get GenderPreference value
     * @return string|null
     */
    public function getGenderPreference()
    {
        return $this->GenderPreference;
    }
    /**
     * Set GenderPreference value
     * @param string $genderPreference
     * @return \StructType\Appointment
     */
    public function setGenderPreference($genderPreference = null)
    {
        // validation for constraint: string
        if (!is_null($genderPreference) && !is_string($genderPreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($genderPreference)), __LINE__);
        }
        $this->GenderPreference = $genderPreference;
        return $this;
    }
    /**
     * Get ProviderID value
     * @return string|null
     */
    public function getProviderID()
    {
        return $this->ProviderID;
    }
    /**
     * Set ProviderID value
     * @param string $providerID
     * @return \StructType\Appointment
     */
    public function setProviderID($providerID = null)
    {
        // validation for constraint: string
        if (!is_null($providerID) && !is_string($providerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providerID)), __LINE__);
        }
        $this->ProviderID = $providerID;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\ActionCode::valueIsValid()
     * @uses \EnumType\ActionCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\Appointment
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionCode::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\ActionCode::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $iD
     * @return \StructType\Appointment
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\AppointmentStatus::valueIsValid()
     * @uses \EnumType\AppointmentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Appointment
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AppointmentStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\AppointmentStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StartDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDateTime()
    {
        return isset($this->StartDateTime) ? $this->StartDateTime : null;
    }
    /**
     * Set StartDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDateTime
     * @return \StructType\Appointment
     */
    public function setStartDateTime($startDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTime) && !is_string($startDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDateTime)), __LINE__);
        }
        if (is_null($startDateTime) || (is_array($startDateTime) && empty($startDateTime))) {
            unset($this->StartDateTime);
        } else {
            $this->StartDateTime = $startDateTime;
        }
        return $this;
    }
    /**
     * Get EndDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDateTime()
    {
        return isset($this->EndDateTime) ? $this->EndDateTime : null;
    }
    /**
     * Set EndDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDateTime
     * @return \StructType\Appointment
     */
    public function setEndDateTime($endDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($endDateTime) && !is_string($endDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDateTime)), __LINE__);
        }
        if (is_null($endDateTime) || (is_array($endDateTime) && empty($endDateTime))) {
            unset($this->EndDateTime);
        } else {
            $this->EndDateTime = $endDateTime;
        }
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\Appointment
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get StaffRequested value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getStaffRequested()
    {
        return isset($this->StaffRequested) ? $this->StaffRequested : null;
    }
    /**
     * Set StaffRequested value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $staffRequested
     * @return \StructType\Appointment
     */
    public function setStaffRequested($staffRequested = null)
    {
        // validation for constraint: boolean
        if (!is_null($staffRequested) && !is_bool($staffRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($staffRequested)), __LINE__);
        }
        if (is_null($staffRequested) || (is_array($staffRequested) && empty($staffRequested))) {
            unset($this->StaffRequested);
        } else {
            $this->StaffRequested = $staffRequested;
        }
        return $this;
    }
    /**
     * Get Program value
     * @return \StructType\Program|null
     */
    public function getProgram()
    {
        return $this->Program;
    }
    /**
     * Set Program value
     * @param \StructType\Program $program
     * @return \StructType\Appointment
     */
    public function setProgram(\StructType\Program $program = null)
    {
        $this->Program = $program;
        return $this;
    }
    /**
     * Get SessionType value
     * @return \StructType\SessionType|null
     */
    public function getSessionType()
    {
        return $this->SessionType;
    }
    /**
     * Set SessionType value
     * @param \StructType\SessionType $sessionType
     * @return \StructType\Appointment
     */
    public function setSessionType(\StructType\SessionType $sessionType = null)
    {
        $this->SessionType = $sessionType;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Location|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\Location $location
     * @return \StructType\Appointment
     */
    public function setLocation(\StructType\Location $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Staff value
     * @return \StructType\Staff|null
     */
    public function getStaff()
    {
        return $this->Staff;
    }
    /**
     * Set Staff value
     * @param \StructType\Staff $staff
     * @return \StructType\Appointment
     */
    public function setStaff(\StructType\Staff $staff = null)
    {
        $this->Staff = $staff;
        return $this;
    }
    /**
     * Get Client value
     * @return \StructType\Client|null
     */
    public function getClient()
    {
        return $this->Client;
    }
    /**
     * Set Client value
     * @param \StructType\Client $client
     * @return \StructType\Appointment
     */
    public function setClient(\StructType\Client $client = null)
    {
        $this->Client = $client;
        return $this;
    }
    /**
     * Get FirstAppointment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFirstAppointment()
    {
        return isset($this->FirstAppointment) ? $this->FirstAppointment : null;
    }
    /**
     * Set FirstAppointment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $firstAppointment
     * @return \StructType\Appointment
     */
    public function setFirstAppointment($firstAppointment = null)
    {
        // validation for constraint: boolean
        if (!is_null($firstAppointment) && !is_bool($firstAppointment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($firstAppointment)), __LINE__);
        }
        if (is_null($firstAppointment) || (is_array($firstAppointment) && empty($firstAppointment))) {
            unset($this->FirstAppointment);
        } else {
            $this->FirstAppointment = $firstAppointment;
        }
        return $this;
    }
    /**
     * Get ClientService value
     * @return \StructType\ClientService|null
     */
    public function getClientService()
    {
        return $this->ClientService;
    }
    /**
     * Set ClientService value
     * @param \StructType\ClientService $clientService
     * @return \StructType\Appointment
     */
    public function setClientService(\StructType\ClientService $clientService = null)
    {
        $this->ClientService = $clientService;
        return $this;
    }
    /**
     * Get Resources value
     * @return \ArrayType\ArrayOfResource|null
     */
    public function getResources()
    {
        return $this->Resources;
    }
    /**
     * Set Resources value
     * @param \ArrayType\ArrayOfResource $resources
     * @return \StructType\Appointment
     */
    public function setResources(\ArrayType\ArrayOfResource $resources = null)
    {
        $this->Resources = $resources;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Appointment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
