<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSaleItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfSaleItem extends AbstractStructArrayBase
{
    /**
     * The SaleItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SaleItem[]
     */
    public $SaleItem;
    /**
     * Constructor method for ArrayOfSaleItem
     * @uses ArrayOfSaleItem::setSaleItem()
     * @param \StructType\SaleItem[] $saleItem
     */
    public function __construct(array $saleItem = array())
    {
        $this
            ->setSaleItem($saleItem);
    }
    /**
     * Get SaleItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SaleItem[]|null
     */
    public function getSaleItem()
    {
        return isset($this->SaleItem) ? $this->SaleItem : null;
    }
    /**
     * Set SaleItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SaleItem[] $saleItem
     * @return \ArrayType\ArrayOfSaleItem
     */
    public function setSaleItem(array $saleItem = array())
    {
        foreach ($saleItem as $arrayOfSaleItemSaleItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfSaleItemSaleItemItem instanceof \StructType\SaleItem) {
                throw new \InvalidArgumentException(sprintf('The SaleItem property can only contain items of \StructType\SaleItem, "%s" given', is_object($arrayOfSaleItemSaleItemItem) ? get_class($arrayOfSaleItemSaleItemItem) : gettype($arrayOfSaleItemSaleItemItem)), __LINE__);
            }
        }
        if (is_null($saleItem) || (is_array($saleItem) && empty($saleItem))) {
            unset($this->SaleItem);
        } else {
            $this->SaleItem = $saleItem;
        }
        return $this;
    }
    /**
     * Add item to SaleItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SaleItem $item
     * @return \ArrayType\ArrayOfSaleItem
     */
    public function addToSaleItem(\StructType\SaleItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SaleItem) {
            throw new \InvalidArgumentException(sprintf('The SaleItem property can only contain items of \StructType\SaleItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SaleItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SaleItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SaleItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SaleItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SaleItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SaleItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SaleItem
     */
    public function getAttributeName()
    {
        return 'SaleItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSaleItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
