<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfResource ArrayType
 * @subpackage Arrays
 */
class ArrayOfResource extends AbstractStructArrayBase
{
    /**
     * The Resource
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Resource[]
     */
    public $Resource;
    /**
     * Constructor method for ArrayOfResource
     * @uses ArrayOfResource::setResource()
     * @param \StructType\Resource[] $resource
     */
    public function __construct(array $resource = array())
    {
        $this
            ->setResource($resource);
    }
    /**
     * Get Resource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Resource[]|null
     */
    public function getResource()
    {
        return isset($this->Resource) ? $this->Resource : null;
    }
    /**
     * Set Resource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Resource[] $resource
     * @return \ArrayType\ArrayOfResource
     */
    public function setResource(array $resource = array())
    {
        foreach ($resource as $arrayOfResourceResourceItem) {
            // validation for constraint: itemType
            if (!$arrayOfResourceResourceItem instanceof \StructType\Resource) {
                throw new \InvalidArgumentException(sprintf('The Resource property can only contain items of \StructType\Resource, "%s" given', is_object($arrayOfResourceResourceItem) ? get_class($arrayOfResourceResourceItem) : gettype($arrayOfResourceResourceItem)), __LINE__);
            }
        }
        if (is_null($resource) || (is_array($resource) && empty($resource))) {
            unset($this->Resource);
        } else {
            $this->Resource = $resource;
        }
        return $this;
    }
    /**
     * Add item to Resource value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource $item
     * @return \ArrayType\ArrayOfResource
     */
    public function addToResource(\StructType\Resource $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource) {
            throw new \InvalidArgumentException(sprintf('The Resource property can only contain items of \StructType\Resource, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Resource[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Resource|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Resource|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Resource|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Resource|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Resource|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Resource
     */
    public function getAttributeName()
    {
        return 'Resource';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfResource
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
