<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPurchasedItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfPurchasedItem extends AbstractStructArrayBase
{
    /**
     * The PurchasedItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PurchasedItem[]
     */
    public $PurchasedItem;
    /**
     * Constructor method for ArrayOfPurchasedItem
     * @uses ArrayOfPurchasedItem::setPurchasedItem()
     * @param \StructType\PurchasedItem[] $purchasedItem
     */
    public function __construct(array $purchasedItem = array())
    {
        $this
            ->setPurchasedItem($purchasedItem);
    }
    /**
     * Get PurchasedItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PurchasedItem[]|null
     */
    public function getPurchasedItem()
    {
        return isset($this->PurchasedItem) ? $this->PurchasedItem : null;
    }
    /**
     * Set PurchasedItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PurchasedItem[] $purchasedItem
     * @return \ArrayType\ArrayOfPurchasedItem
     */
    public function setPurchasedItem(array $purchasedItem = array())
    {
        foreach ($purchasedItem as $arrayOfPurchasedItemPurchasedItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfPurchasedItemPurchasedItemItem instanceof \StructType\PurchasedItem) {
                throw new \InvalidArgumentException(sprintf('The PurchasedItem property can only contain items of \StructType\PurchasedItem, "%s" given', is_object($arrayOfPurchasedItemPurchasedItemItem) ? get_class($arrayOfPurchasedItemPurchasedItemItem) : gettype($arrayOfPurchasedItemPurchasedItemItem)), __LINE__);
            }
        }
        if (is_null($purchasedItem) || (is_array($purchasedItem) && empty($purchasedItem))) {
            unset($this->PurchasedItem);
        } else {
            $this->PurchasedItem = $purchasedItem;
        }
        return $this;
    }
    /**
     * Add item to PurchasedItem value
     * @throws \InvalidArgumentException
     * @param \StructType\PurchasedItem $item
     * @return \ArrayType\ArrayOfPurchasedItem
     */
    public function addToPurchasedItem(\StructType\PurchasedItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PurchasedItem) {
            throw new \InvalidArgumentException(sprintf('The PurchasedItem property can only contain items of \StructType\PurchasedItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PurchasedItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PurchasedItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PurchasedItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PurchasedItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PurchasedItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PurchasedItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PurchasedItem
     */
    public function getAttributeName()
    {
        return 'PurchasedItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPurchasedItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
