<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProgram ArrayType
 * @subpackage Arrays
 */
class ArrayOfProgram extends AbstractStructArrayBase
{
    /**
     * The Program
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Program[]
     */
    public $Program;
    /**
     * Constructor method for ArrayOfProgram
     * @uses ArrayOfProgram::setProgram()
     * @param \StructType\Program[] $program
     */
    public function __construct(array $program = array())
    {
        $this
            ->setProgram($program);
    }
    /**
     * Get Program value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Program[]|null
     */
    public function getProgram()
    {
        return isset($this->Program) ? $this->Program : null;
    }
    /**
     * Set Program value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Program[] $program
     * @return \ArrayType\ArrayOfProgram
     */
    public function setProgram(array $program = array())
    {
        foreach ($program as $arrayOfProgramProgramItem) {
            // validation for constraint: itemType
            if (!$arrayOfProgramProgramItem instanceof \StructType\Program) {
                throw new \InvalidArgumentException(sprintf('The Program property can only contain items of \StructType\Program, "%s" given', is_object($arrayOfProgramProgramItem) ? get_class($arrayOfProgramProgramItem) : gettype($arrayOfProgramProgramItem)), __LINE__);
            }
        }
        if (is_null($program) || (is_array($program) && empty($program))) {
            unset($this->Program);
        } else {
            $this->Program = $program;
        }
        return $this;
    }
    /**
     * Add item to Program value
     * @throws \InvalidArgumentException
     * @param \StructType\Program $item
     * @return \ArrayType\ArrayOfProgram
     */
    public function addToProgram(\StructType\Program $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Program) {
            throw new \InvalidArgumentException(sprintf('The Program property can only contain items of \StructType\Program, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Program[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Program|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Program|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Program|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Program|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Program|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Program
     */
    public function getAttributeName()
    {
        return 'Program';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfProgram
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
