<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContactLogType ArrayType
 * @subpackage Arrays
 */
class ArrayOfContactLogType extends AbstractStructArrayBase
{
    /**
     * The ContactLogType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactLogType[]
     */
    public $ContactLogType;
    /**
     * Constructor method for ArrayOfContactLogType
     * @uses ArrayOfContactLogType::setContactLogType()
     * @param \StructType\ContactLogType[] $contactLogType
     */
    public function __construct(array $contactLogType = array())
    {
        $this
            ->setContactLogType($contactLogType);
    }
    /**
     * Get ContactLogType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactLogType[]|null
     */
    public function getContactLogType()
    {
        return isset($this->ContactLogType) ? $this->ContactLogType : null;
    }
    /**
     * Set ContactLogType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContactLogType[] $contactLogType
     * @return \ArrayType\ArrayOfContactLogType
     */
    public function setContactLogType(array $contactLogType = array())
    {
        foreach ($contactLogType as $arrayOfContactLogTypeContactLogTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfContactLogTypeContactLogTypeItem instanceof \StructType\ContactLogType) {
                throw new \InvalidArgumentException(sprintf('The ContactLogType property can only contain items of \StructType\ContactLogType, "%s" given', is_object($arrayOfContactLogTypeContactLogTypeItem) ? get_class($arrayOfContactLogTypeContactLogTypeItem) : gettype($arrayOfContactLogTypeContactLogTypeItem)), __LINE__);
            }
        }
        if (is_null($contactLogType) || (is_array($contactLogType) && empty($contactLogType))) {
            unset($this->ContactLogType);
        } else {
            $this->ContactLogType = $contactLogType;
        }
        return $this;
    }
    /**
     * Add item to ContactLogType value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactLogType $item
     * @return \ArrayType\ArrayOfContactLogType
     */
    public function addToContactLogType(\StructType\ContactLogType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactLogType) {
            throw new \InvalidArgumentException(sprintf('The ContactLogType property can only contain items of \StructType\ContactLogType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactLogType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ContactLogType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ContactLogType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ContactLogType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ContactLogType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ContactLogType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContactLogType
     */
    public function getAttributeName()
    {
        return 'ContactLogType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfContactLogType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
