<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContactLogComment ArrayType
 * @subpackage Arrays
 */
class ArrayOfContactLogComment extends AbstractStructArrayBase
{
    /**
     * The ContactLogComment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactLogComment[]
     */
    public $ContactLogComment;
    /**
     * Constructor method for ArrayOfContactLogComment
     * @uses ArrayOfContactLogComment::setContactLogComment()
     * @param \StructType\ContactLogComment[] $contactLogComment
     */
    public function __construct(array $contactLogComment = array())
    {
        $this
            ->setContactLogComment($contactLogComment);
    }
    /**
     * Get ContactLogComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactLogComment[]|null
     */
    public function getContactLogComment()
    {
        return isset($this->ContactLogComment) ? $this->ContactLogComment : null;
    }
    /**
     * Set ContactLogComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContactLogComment[] $contactLogComment
     * @return \ArrayType\ArrayOfContactLogComment
     */
    public function setContactLogComment(array $contactLogComment = array())
    {
        foreach ($contactLogComment as $arrayOfContactLogCommentContactLogCommentItem) {
            // validation for constraint: itemType
            if (!$arrayOfContactLogCommentContactLogCommentItem instanceof \StructType\ContactLogComment) {
                throw new \InvalidArgumentException(sprintf('The ContactLogComment property can only contain items of \StructType\ContactLogComment, "%s" given', is_object($arrayOfContactLogCommentContactLogCommentItem) ? get_class($arrayOfContactLogCommentContactLogCommentItem) : gettype($arrayOfContactLogCommentContactLogCommentItem)), __LINE__);
            }
        }
        if (is_null($contactLogComment) || (is_array($contactLogComment) && empty($contactLogComment))) {
            unset($this->ContactLogComment);
        } else {
            $this->ContactLogComment = $contactLogComment;
        }
        return $this;
    }
    /**
     * Add item to ContactLogComment value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactLogComment $item
     * @return \ArrayType\ArrayOfContactLogComment
     */
    public function addToContactLogComment(\StructType\ContactLogComment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactLogComment) {
            throw new \InvalidArgumentException(sprintf('The ContactLogComment property can only contain items of \StructType\ContactLogComment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactLogComment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ContactLogComment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ContactLogComment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ContactLogComment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ContactLogComment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ContactLogComment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContactLogComment
     */
    public function getAttributeName()
    {
        return 'ContactLogComment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfContactLogComment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
