<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClientMembership ArrayType
 * @subpackage Arrays
 */
class ArrayOfClientMembership extends AbstractStructArrayBase
{
    /**
     * The ClientMembership
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClientMembership[]
     */
    public $ClientMembership;
    /**
     * Constructor method for ArrayOfClientMembership
     * @uses ArrayOfClientMembership::setClientMembership()
     * @param \StructType\ClientMembership[] $clientMembership
     */
    public function __construct(array $clientMembership = array())
    {
        $this
            ->setClientMembership($clientMembership);
    }
    /**
     * Get ClientMembership value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClientMembership[]|null
     */
    public function getClientMembership()
    {
        return isset($this->ClientMembership) ? $this->ClientMembership : null;
    }
    /**
     * Set ClientMembership value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClientMembership[] $clientMembership
     * @return \ArrayType\ArrayOfClientMembership
     */
    public function setClientMembership(array $clientMembership = array())
    {
        foreach ($clientMembership as $arrayOfClientMembershipClientMembershipItem) {
            // validation for constraint: itemType
            if (!$arrayOfClientMembershipClientMembershipItem instanceof \StructType\ClientMembership) {
                throw new \InvalidArgumentException(sprintf('The ClientMembership property can only contain items of \StructType\ClientMembership, "%s" given', is_object($arrayOfClientMembershipClientMembershipItem) ? get_class($arrayOfClientMembershipClientMembershipItem) : gettype($arrayOfClientMembershipClientMembershipItem)), __LINE__);
            }
        }
        if (is_null($clientMembership) || (is_array($clientMembership) && empty($clientMembership))) {
            unset($this->ClientMembership);
        } else {
            $this->ClientMembership = $clientMembership;
        }
        return $this;
    }
    /**
     * Add item to ClientMembership value
     * @throws \InvalidArgumentException
     * @param \StructType\ClientMembership $item
     * @return \ArrayType\ArrayOfClientMembership
     */
    public function addToClientMembership(\StructType\ClientMembership $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ClientMembership) {
            throw new \InvalidArgumentException(sprintf('The ClientMembership property can only contain items of \StructType\ClientMembership, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ClientMembership[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ClientMembership|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ClientMembership|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ClientMembership|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ClientMembership|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ClientMembership|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ClientMembership
     */
    public function getAttributeName()
    {
        return 'ClientMembership';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfClientMembership
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
