<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClientIndexValue ArrayType
 * @subpackage Arrays
 */
class ArrayOfClientIndexValue extends AbstractStructArrayBase
{
    /**
     * The ClientIndexValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClientIndexValue[]
     */
    public $ClientIndexValue;
    /**
     * Constructor method for ArrayOfClientIndexValue
     * @uses ArrayOfClientIndexValue::setClientIndexValue()
     * @param \StructType\ClientIndexValue[] $clientIndexValue
     */
    public function __construct(array $clientIndexValue = array())
    {
        $this
            ->setClientIndexValue($clientIndexValue);
    }
    /**
     * Get ClientIndexValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClientIndexValue[]|null
     */
    public function getClientIndexValue()
    {
        return isset($this->ClientIndexValue) ? $this->ClientIndexValue : null;
    }
    /**
     * Set ClientIndexValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClientIndexValue[] $clientIndexValue
     * @return \ArrayType\ArrayOfClientIndexValue
     */
    public function setClientIndexValue(array $clientIndexValue = array())
    {
        foreach ($clientIndexValue as $arrayOfClientIndexValueClientIndexValueItem) {
            // validation for constraint: itemType
            if (!$arrayOfClientIndexValueClientIndexValueItem instanceof \StructType\ClientIndexValue) {
                throw new \InvalidArgumentException(sprintf('The ClientIndexValue property can only contain items of \StructType\ClientIndexValue, "%s" given', is_object($arrayOfClientIndexValueClientIndexValueItem) ? get_class($arrayOfClientIndexValueClientIndexValueItem) : gettype($arrayOfClientIndexValueClientIndexValueItem)), __LINE__);
            }
        }
        if (is_null($clientIndexValue) || (is_array($clientIndexValue) && empty($clientIndexValue))) {
            unset($this->ClientIndexValue);
        } else {
            $this->ClientIndexValue = $clientIndexValue;
        }
        return $this;
    }
    /**
     * Add item to ClientIndexValue value
     * @throws \InvalidArgumentException
     * @param \StructType\ClientIndexValue $item
     * @return \ArrayType\ArrayOfClientIndexValue
     */
    public function addToClientIndexValue(\StructType\ClientIndexValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ClientIndexValue) {
            throw new \InvalidArgumentException(sprintf('The ClientIndexValue property can only contain items of \StructType\ClientIndexValue, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ClientIndexValue[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ClientIndexValue|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ClientIndexValue|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ClientIndexValue|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ClientIndexValue|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ClientIndexValue|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ClientIndexValue
     */
    public function getAttributeName()
    {
        return 'ClientIndexValue';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfClientIndexValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
