<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClientContract ArrayType
 * @subpackage Arrays
 */
class ArrayOfClientContract extends AbstractStructArrayBase
{
    /**
     * The ClientContract
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClientContract[]
     */
    public $ClientContract;
    /**
     * Constructor method for ArrayOfClientContract
     * @uses ArrayOfClientContract::setClientContract()
     * @param \StructType\ClientContract[] $clientContract
     */
    public function __construct(array $clientContract = array())
    {
        $this
            ->setClientContract($clientContract);
    }
    /**
     * Get ClientContract value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClientContract[]|null
     */
    public function getClientContract()
    {
        return isset($this->ClientContract) ? $this->ClientContract : null;
    }
    /**
     * Set ClientContract value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClientContract[] $clientContract
     * @return \ArrayType\ArrayOfClientContract
     */
    public function setClientContract(array $clientContract = array())
    {
        foreach ($clientContract as $arrayOfClientContractClientContractItem) {
            // validation for constraint: itemType
            if (!$arrayOfClientContractClientContractItem instanceof \StructType\ClientContract) {
                throw new \InvalidArgumentException(sprintf('The ClientContract property can only contain items of \StructType\ClientContract, "%s" given', is_object($arrayOfClientContractClientContractItem) ? get_class($arrayOfClientContractClientContractItem) : gettype($arrayOfClientContractClientContractItem)), __LINE__);
            }
        }
        if (is_null($clientContract) || (is_array($clientContract) && empty($clientContract))) {
            unset($this->ClientContract);
        } else {
            $this->ClientContract = $clientContract;
        }
        return $this;
    }
    /**
     * Add item to ClientContract value
     * @throws \InvalidArgumentException
     * @param \StructType\ClientContract $item
     * @return \ArrayType\ArrayOfClientContract
     */
    public function addToClientContract(\StructType\ClientContract $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ClientContract) {
            throw new \InvalidArgumentException(sprintf('The ClientContract property can only contain items of \StructType\ClientContract, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ClientContract[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ClientContract|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ClientContract|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ClientContract|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ClientContract|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ClientContract|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ClientContract
     */
    public function getAttributeName()
    {
        return 'ClientContract';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfClientContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
