<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAppointment ArrayType
 * @subpackage Arrays
 */
class ArrayOfAppointment extends AbstractStructArrayBase
{
    /**
     * The Appointment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Appointment[]
     */
    public $Appointment;
    /**
     * Constructor method for ArrayOfAppointment
     * @uses ArrayOfAppointment::setAppointment()
     * @param \StructType\Appointment[] $appointment
     */
    public function __construct(array $appointment = array())
    {
        $this
            ->setAppointment($appointment);
    }
    /**
     * Get Appointment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Appointment[]|null
     */
    public function getAppointment()
    {
        return isset($this->Appointment) ? $this->Appointment : null;
    }
    /**
     * Set Appointment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Appointment[] $appointment
     * @return \ArrayType\ArrayOfAppointment
     */
    public function setAppointment(array $appointment = array())
    {
        foreach ($appointment as $arrayOfAppointmentAppointmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfAppointmentAppointmentItem instanceof \StructType\Appointment) {
                throw new \InvalidArgumentException(sprintf('The Appointment property can only contain items of \StructType\Appointment, "%s" given', is_object($arrayOfAppointmentAppointmentItem) ? get_class($arrayOfAppointmentAppointmentItem) : gettype($arrayOfAppointmentAppointmentItem)), __LINE__);
            }
        }
        if (is_null($appointment) || (is_array($appointment) && empty($appointment))) {
            unset($this->Appointment);
        } else {
            $this->Appointment = $appointment;
        }
        return $this;
    }
    /**
     * Add item to Appointment value
     * @throws \InvalidArgumentException
     * @param \StructType\Appointment $item
     * @return \ArrayType\ArrayOfAppointment
     */
    public function addToAppointment(\StructType\Appointment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Appointment) {
            throw new \InvalidArgumentException(sprintf('The Appointment property can only contain items of \StructType\Appointment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Appointment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Appointment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Appointment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Appointment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Appointment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Appointment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Appointment
     */
    public function getAttributeName()
    {
        return 'Appointment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAppointment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
