<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.mindbodyonline.com/0_5_1/ClientService.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.mindbodyonline.com/0_5_1/ClientService.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddArrival operation/method
 */
if ($add->AddArrival(new \StructType\AddArrival()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddOrUpdateClients operation/method
 */
if ($add->AddOrUpdateClients(new \StructType\AddOrUpdateClients()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddOrUpdateContactLogs operation/method
 */
if ($add->AddOrUpdateContactLogs(new \StructType\AddOrUpdateContactLogs()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddClientFormulaNote operation/method
 */
if ($add->AddClientFormulaNote(new \StructType\AddClientFormulaNote()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateClientCrossRegional operation/method
 */
if ($update->UpdateClientCrossRegional(new \StructType\UpdateClientCrossRegional()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateClientServices operation/method
 */
if ($update->UpdateClientServices(new \StructType\UpdateClientServices()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetClients operation/method
 */
if ($get->GetClients(new \StructType\GetClients()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCrossRegionalClientAssociations operation/method
 */
if ($get->GetCrossRegionalClientAssociations(new \StructType\GetCrossRegionalClientAssociations()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomClientFields operation/method
 */
if ($get->GetCustomClientFields(new \StructType\GetCustomClientFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientIndexes operation/method
 */
if ($get->GetClientIndexes(new \StructType\GetClientIndexes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientContactLogs operation/method
 */
if ($get->GetClientContactLogs(new \StructType\GetClientContactLogs()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContactLogTypes operation/method
 */
if ($get->GetContactLogTypes(new \StructType\GetContactLogTypes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientFormulaNotes operation/method
 */
if ($get->GetClientFormulaNotes(new \StructType\GetClientFormulaNotes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientReferralTypes operation/method
 */
if ($get->GetClientReferralTypes(new \StructType\GetClientReferralTypes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetActiveClientMemberships operation/method
 */
if ($get->GetActiveClientMemberships(new \StructType\GetActiveClientMemberships()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientContracts operation/method
 */
if ($get->GetClientContracts(new \StructType\GetClientContracts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientAccountBalances operation/method
 */
if ($get->GetClientAccountBalances(new \StructType\GetClientAccountBalances()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientServices operation/method
 */
if ($get->GetClientServices(new \StructType\GetClientServices()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientVisits operation/method
 */
if ($get->GetClientVisits(new \StructType\GetClientVisits()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientPurchases operation/method
 */
if ($get->GetClientPurchases(new \StructType\GetClientPurchases()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientSchedule operation/method
 */
if ($get->GetClientSchedule(new \StructType\GetClientSchedule()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRequiredClientFields operation/method
 */
if ($get->GetRequiredClientFields(new \StructType\GetRequiredClientFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \ServiceType\Upload($options);
/**
 * Sample call for UploadClientDocument operation/method
 */
if ($upload->UploadClientDocument(new \StructType\UploadClientDocument()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Sample call for UploadClientPhoto operation/method
 */
if ($upload->UploadClientPhoto(new \StructType\UploadClientPhoto()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteClientFormulaNote operation/method
 */
if ($delete->DeleteClientFormulaNote(new \StructType\DeleteClientFormulaNote()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
/**
 * Sample call for ValidateLogin operation/method
 */
if ($validate->ValidateLogin(new \StructType\ValidateLogin()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for SendUserNewPassword operation/method
 */
if ($send->SendUserNewPassword(new \StructType\SendUserNewPassword()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
