<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Visit StructType
 * @subpackage Structs
 */
class Visit extends MBObject
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The ClassID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ClassID;
    /**
     * The AppointmentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AppointmentID;
    /**
     * The AppointmentGenderPreference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AppointmentGenderPreference;
    /**
     * The StartDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartDateTime;
    /**
     * The LateCancelled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $LateCancelled;
    /**
     * The EndDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EndDateTime;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Staff
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Staff
     */
    public $Staff;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Location
     */
    public $Location;
    /**
     * The Client
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Client
     */
    public $Client;
    /**
     * The WebSignup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $WebSignup;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The SignedIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SignedIn;
    /**
     * The AppointmentStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AppointmentStatus;
    /**
     * The MakeUp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MakeUp;
    /**
     * The Service
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ClientService
     */
    public $Service;
    /**
     * The LastModifiedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDateTime;
    /**
     * Constructor method for Visit
     * @uses Visit::setID()
     * @uses Visit::setClassID()
     * @uses Visit::setAppointmentID()
     * @uses Visit::setAppointmentGenderPreference()
     * @uses Visit::setStartDateTime()
     * @uses Visit::setLateCancelled()
     * @uses Visit::setEndDateTime()
     * @uses Visit::setName()
     * @uses Visit::setStaff()
     * @uses Visit::setLocation()
     * @uses Visit::setClient()
     * @uses Visit::setWebSignup()
     * @uses Visit::setAction()
     * @uses Visit::setSignedIn()
     * @uses Visit::setAppointmentStatus()
     * @uses Visit::setMakeUp()
     * @uses Visit::setService()
     * @uses Visit::setLastModifiedDateTime()
     * @param int $iD
     * @param int $classID
     * @param int $appointmentID
     * @param string $appointmentGenderPreference
     * @param string $startDateTime
     * @param bool $lateCancelled
     * @param string $endDateTime
     * @param string $name
     * @param \StructType\Staff $staff
     * @param \StructType\Location $location
     * @param \StructType\Client $client
     * @param bool $webSignup
     * @param string $action
     * @param bool $signedIn
     * @param string $appointmentStatus
     * @param bool $makeUp
     * @param \StructType\ClientService $service
     * @param string $lastModifiedDateTime
     */
    public function __construct($iD = null, $classID = null, $appointmentID = null, $appointmentGenderPreference = null, $startDateTime = null, $lateCancelled = null, $endDateTime = null, $name = null, \StructType\Staff $staff = null, \StructType\Location $location = null, \StructType\Client $client = null, $webSignup = null, $action = null, $signedIn = null, $appointmentStatus = null, $makeUp = null, \StructType\ClientService $service = null, $lastModifiedDateTime = null)
    {
        $this
            ->setID($iD)
            ->setClassID($classID)
            ->setAppointmentID($appointmentID)
            ->setAppointmentGenderPreference($appointmentGenderPreference)
            ->setStartDateTime($startDateTime)
            ->setLateCancelled($lateCancelled)
            ->setEndDateTime($endDateTime)
            ->setName($name)
            ->setStaff($staff)
            ->setLocation($location)
            ->setClient($client)
            ->setWebSignup($webSignup)
            ->setAction($action)
            ->setSignedIn($signedIn)
            ->setAppointmentStatus($appointmentStatus)
            ->setMakeUp($makeUp)
            ->setService($service)
            ->setLastModifiedDateTime($lastModifiedDateTime);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Visit
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get ClassID value
     * @return int|null
     */
    public function getClassID()
    {
        return $this->ClassID;
    }
    /**
     * Set ClassID value
     * @param int $classID
     * @return \StructType\Visit
     */
    public function setClassID($classID = null)
    {
        // validation for constraint: int
        if (!is_null($classID) && !is_numeric($classID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($classID)), __LINE__);
        }
        $this->ClassID = $classID;
        return $this;
    }
    /**
     * Get AppointmentID value
     * @return int|null
     */
    public function getAppointmentID()
    {
        return $this->AppointmentID;
    }
    /**
     * Set AppointmentID value
     * @param int $appointmentID
     * @return \StructType\Visit
     */
    public function setAppointmentID($appointmentID = null)
    {
        // validation for constraint: int
        if (!is_null($appointmentID) && !is_numeric($appointmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($appointmentID)), __LINE__);
        }
        $this->AppointmentID = $appointmentID;
        return $this;
    }
    /**
     * Get AppointmentGenderPreference value
     * @return string|null
     */
    public function getAppointmentGenderPreference()
    {
        return $this->AppointmentGenderPreference;
    }
    /**
     * Set AppointmentGenderPreference value
     * @param string $appointmentGenderPreference
     * @return \StructType\Visit
     */
    public function setAppointmentGenderPreference($appointmentGenderPreference = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentGenderPreference) && !is_string($appointmentGenderPreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appointmentGenderPreference)), __LINE__);
        }
        $this->AppointmentGenderPreference = $appointmentGenderPreference;
        return $this;
    }
    /**
     * Get StartDateTime value
     * @return string|null
     */
    public function getStartDateTime()
    {
        return $this->StartDateTime;
    }
    /**
     * Set StartDateTime value
     * @param string $startDateTime
     * @return \StructType\Visit
     */
    public function setStartDateTime($startDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTime) && !is_string($startDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDateTime)), __LINE__);
        }
        $this->StartDateTime = $startDateTime;
        return $this;
    }
    /**
     * Get LateCancelled value
     * @return bool|null
     */
    public function getLateCancelled()
    {
        return $this->LateCancelled;
    }
    /**
     * Set LateCancelled value
     * @param bool $lateCancelled
     * @return \StructType\Visit
     */
    public function setLateCancelled($lateCancelled = null)
    {
        // validation for constraint: boolean
        if (!is_null($lateCancelled) && !is_bool($lateCancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($lateCancelled)), __LINE__);
        }
        $this->LateCancelled = $lateCancelled;
        return $this;
    }
    /**
     * Get EndDateTime value
     * @return string|null
     */
    public function getEndDateTime()
    {
        return $this->EndDateTime;
    }
    /**
     * Set EndDateTime value
     * @param string $endDateTime
     * @return \StructType\Visit
     */
    public function setEndDateTime($endDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($endDateTime) && !is_string($endDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDateTime)), __LINE__);
        }
        $this->EndDateTime = $endDateTime;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Visit
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Staff value
     * @return \StructType\Staff|null
     */
    public function getStaff()
    {
        return $this->Staff;
    }
    /**
     * Set Staff value
     * @param \StructType\Staff $staff
     * @return \StructType\Visit
     */
    public function setStaff(\StructType\Staff $staff = null)
    {
        $this->Staff = $staff;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Location|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\Location $location
     * @return \StructType\Visit
     */
    public function setLocation(\StructType\Location $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Client value
     * @return \StructType\Client|null
     */
    public function getClient()
    {
        return $this->Client;
    }
    /**
     * Set Client value
     * @param \StructType\Client $client
     * @return \StructType\Visit
     */
    public function setClient(\StructType\Client $client = null)
    {
        $this->Client = $client;
        return $this;
    }
    /**
     * Get WebSignup value
     * @return bool|null
     */
    public function getWebSignup()
    {
        return $this->WebSignup;
    }
    /**
     * Set WebSignup value
     * @param bool $webSignup
     * @return \StructType\Visit
     */
    public function setWebSignup($webSignup = null)
    {
        // validation for constraint: boolean
        if (!is_null($webSignup) && !is_bool($webSignup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($webSignup)), __LINE__);
        }
        $this->WebSignup = $webSignup;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\ActionCode::valueIsValid()
     * @uses \EnumType\ActionCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\Visit
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionCode::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\ActionCode::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get SignedIn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSignedIn()
    {
        return isset($this->SignedIn) ? $this->SignedIn : null;
    }
    /**
     * Set SignedIn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $signedIn
     * @return \StructType\Visit
     */
    public function setSignedIn($signedIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($signedIn) && !is_bool($signedIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($signedIn)), __LINE__);
        }
        if (is_null($signedIn) || (is_array($signedIn) && empty($signedIn))) {
            unset($this->SignedIn);
        } else {
            $this->SignedIn = $signedIn;
        }
        return $this;
    }
    /**
     * Get AppointmentStatus value
     * @return string|null
     */
    public function getAppointmentStatus()
    {
        return $this->AppointmentStatus;
    }
    /**
     * Set AppointmentStatus value
     * @param string $appointmentStatus
     * @return \StructType\Visit
     */
    public function setAppointmentStatus($appointmentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentStatus) && !is_string($appointmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appointmentStatus)), __LINE__);
        }
        $this->AppointmentStatus = $appointmentStatus;
        return $this;
    }
    /**
     * Get MakeUp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMakeUp()
    {
        return isset($this->MakeUp) ? $this->MakeUp : null;
    }
    /**
     * Set MakeUp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $makeUp
     * @return \StructType\Visit
     */
    public function setMakeUp($makeUp = null)
    {
        // validation for constraint: boolean
        if (!is_null($makeUp) && !is_bool($makeUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($makeUp)), __LINE__);
        }
        if (is_null($makeUp) || (is_array($makeUp) && empty($makeUp))) {
            unset($this->MakeUp);
        } else {
            $this->MakeUp = $makeUp;
        }
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\ClientService|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \StructType\ClientService $service
     * @return \StructType\Visit
     */
    public function setService(\StructType\ClientService $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDateTime
     * @return \StructType\Visit
     */
    public function setLastModifiedDateTime($lastModifiedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDateTime) && !is_string($lastModifiedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModifiedDateTime)), __LINE__);
        }
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Visit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
