<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateLoginResult StructType
 * @subpackage Structs
 */
class ValidateLoginResult extends MBResult
{
    /**
     * The GUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GUID;
    /**
     * The Client
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Client
     */
    public $Client;
    /**
     * The Staff
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Staff
     */
    public $Staff;
    /**
     * Constructor method for ValidateLoginResult
     * @uses ValidateLoginResult::setGUID()
     * @uses ValidateLoginResult::setClient()
     * @uses ValidateLoginResult::setStaff()
     * @param string $gUID
     * @param \StructType\Client $client
     * @param \StructType\Staff $staff
     */
    public function __construct($gUID = null, \StructType\Client $client = null, \StructType\Staff $staff = null)
    {
        $this
            ->setGUID($gUID)
            ->setClient($client)
            ->setStaff($staff);
    }
    /**
     * Get GUID value
     * @return string|null
     */
    public function getGUID()
    {
        return $this->GUID;
    }
    /**
     * Set GUID value
     * @param string $gUID
     * @return \StructType\ValidateLoginResult
     */
    public function setGUID($gUID = null)
    {
        // validation for constraint: string
        if (!is_null($gUID) && !is_string($gUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gUID)), __LINE__);
        }
        $this->GUID = $gUID;
        return $this;
    }
    /**
     * Get Client value
     * @return \StructType\Client|null
     */
    public function getClient()
    {
        return $this->Client;
    }
    /**
     * Set Client value
     * @param \StructType\Client $client
     * @return \StructType\ValidateLoginResult
     */
    public function setClient(\StructType\Client $client = null)
    {
        $this->Client = $client;
        return $this;
    }
    /**
     * Get Staff value
     * @return \StructType\Staff|null
     */
    public function getStaff()
    {
        return $this->Staff;
    }
    /**
     * Set Staff value
     * @param \StructType\Staff $staff
     * @return \StructType\ValidateLoginResult
     */
    public function setStaff(\StructType\Staff $staff = null)
    {
        $this->Staff = $staff;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidateLoginResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
