<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserCredentials StructType
 * @subpackage Structs
 */
class UserCredentials extends AbstractStructBase
{
    /**
     * The LocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $LocationID;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The SiteIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $SiteIDs;
    /**
     * Constructor method for UserCredentials
     * @uses UserCredentials::setLocationID()
     * @uses UserCredentials::setUsername()
     * @uses UserCredentials::setPassword()
     * @uses UserCredentials::setSiteIDs()
     * @param int $locationID
     * @param string $username
     * @param string $password
     * @param \ArrayType\ArrayOfInt $siteIDs
     */
    public function __construct($locationID = null, $username = null, $password = null, \ArrayType\ArrayOfInt $siteIDs = null)
    {
        $this
            ->setLocationID($locationID)
            ->setUsername($username)
            ->setPassword($password)
            ->setSiteIDs($siteIDs);
    }
    /**
     * Get LocationID value
     * @return int
     */
    public function getLocationID()
    {
        return $this->LocationID;
    }
    /**
     * Set LocationID value
     * @param int $locationID
     * @return \StructType\UserCredentials
     */
    public function setLocationID($locationID = null)
    {
        // validation for constraint: int
        if (!is_null($locationID) && !is_numeric($locationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($locationID)), __LINE__);
        }
        $this->LocationID = $locationID;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\UserCredentials
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\UserCredentials
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get SiteIDs value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getSiteIDs()
    {
        return $this->SiteIDs;
    }
    /**
     * Set SiteIDs value
     * @param \ArrayType\ArrayOfInt $siteIDs
     * @return \StructType\UserCredentials
     */
    public function setSiteIDs(\ArrayType\ArrayOfInt $siteIDs = null)
    {
        $this->SiteIDs = $siteIDs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserCredentials
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
