<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SessionType StructType
 * @subpackage Structs
 */
class SessionType extends MBObject
{
    /**
     * The DefaultTimeLength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DefaultTimeLength;
    /**
     * The ProgramID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ProgramID;
    /**
     * The NumDeducted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumDeducted;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The SiteID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SiteID;
    /**
     * The CrossRegionalBookingPerformed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $CrossRegionalBookingPerformed;
    /**
     * Constructor method for SessionType
     * @uses SessionType::setDefaultTimeLength()
     * @uses SessionType::setProgramID()
     * @uses SessionType::setNumDeducted()
     * @uses SessionType::setAction()
     * @uses SessionType::setID()
     * @uses SessionType::setName()
     * @uses SessionType::setSiteID()
     * @uses SessionType::setCrossRegionalBookingPerformed()
     * @param int $defaultTimeLength
     * @param int $programID
     * @param int $numDeducted
     * @param string $action
     * @param int $iD
     * @param string $name
     * @param int $siteID
     * @param bool $crossRegionalBookingPerformed
     */
    public function __construct($defaultTimeLength = null, $programID = null, $numDeducted = null, $action = null, $iD = null, $name = null, $siteID = null, $crossRegionalBookingPerformed = null)
    {
        $this
            ->setDefaultTimeLength($defaultTimeLength)
            ->setProgramID($programID)
            ->setNumDeducted($numDeducted)
            ->setAction($action)
            ->setID($iD)
            ->setName($name)
            ->setSiteID($siteID)
            ->setCrossRegionalBookingPerformed($crossRegionalBookingPerformed);
    }
    /**
     * Get DefaultTimeLength value
     * @return int
     */
    public function getDefaultTimeLength()
    {
        return $this->DefaultTimeLength;
    }
    /**
     * Set DefaultTimeLength value
     * @param int $defaultTimeLength
     * @return \StructType\SessionType
     */
    public function setDefaultTimeLength($defaultTimeLength = null)
    {
        // validation for constraint: int
        if (!is_null($defaultTimeLength) && !is_numeric($defaultTimeLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($defaultTimeLength)), __LINE__);
        }
        $this->DefaultTimeLength = $defaultTimeLength;
        return $this;
    }
    /**
     * Get ProgramID value
     * @return int
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param int $programID
     * @return \StructType\SessionType
     */
    public function setProgramID($programID = null)
    {
        // validation for constraint: int
        if (!is_null($programID) && !is_numeric($programID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($programID)), __LINE__);
        }
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get NumDeducted value
     * @return int
     */
    public function getNumDeducted()
    {
        return $this->NumDeducted;
    }
    /**
     * Set NumDeducted value
     * @param int $numDeducted
     * @return \StructType\SessionType
     */
    public function setNumDeducted($numDeducted = null)
    {
        // validation for constraint: int
        if (!is_null($numDeducted) && !is_numeric($numDeducted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numDeducted)), __LINE__);
        }
        $this->NumDeducted = $numDeducted;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\ActionCode::valueIsValid()
     * @uses \EnumType\ActionCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\SessionType
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionCode::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\ActionCode::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $iD
     * @return \StructType\SessionType
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\SessionType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get SiteID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSiteID()
    {
        return isset($this->SiteID) ? $this->SiteID : null;
    }
    /**
     * Set SiteID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $siteID
     * @return \StructType\SessionType
     */
    public function setSiteID($siteID = null)
    {
        // validation for constraint: int
        if (!is_null($siteID) && !is_numeric($siteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($siteID)), __LINE__);
        }
        if (is_null($siteID) || (is_array($siteID) && empty($siteID))) {
            unset($this->SiteID);
        } else {
            $this->SiteID = $siteID;
        }
        return $this;
    }
    /**
     * Get CrossRegionalBookingPerformed value
     * @return bool|null
     */
    public function getCrossRegionalBookingPerformed()
    {
        return $this->CrossRegionalBookingPerformed;
    }
    /**
     * Set CrossRegionalBookingPerformed value
     * @param bool $crossRegionalBookingPerformed
     * @return \StructType\SessionType
     */
    public function setCrossRegionalBookingPerformed($crossRegionalBookingPerformed = null)
    {
        // validation for constraint: boolean
        if (!is_null($crossRegionalBookingPerformed) && !is_bool($crossRegionalBookingPerformed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($crossRegionalBookingPerformed)), __LINE__);
        }
        $this->CrossRegionalBookingPerformed = $crossRegionalBookingPerformed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SessionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
