<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchasedItem StructType
 * @subpackage Structs
 */
class PurchasedItem extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The IsService
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsService;
    /**
     * Constructor method for PurchasedItem
     * @uses PurchasedItem::setID()
     * @uses PurchasedItem::setIsService()
     * @param int $iD
     * @param bool $isService
     */
    public function __construct($iD = null, $isService = null)
    {
        $this
            ->setID($iD)
            ->setIsService($isService);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\PurchasedItem
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IsService value
     * @return bool
     */
    public function getIsService()
    {
        return $this->IsService;
    }
    /**
     * Set IsService value
     * @param bool $isService
     * @return \StructType\PurchasedItem
     */
    public function setIsService($isService = null)
    {
        // validation for constraint: boolean
        if (!is_null($isService) && !is_bool($isService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isService)), __LINE__);
        }
        $this->IsService = $isService;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PurchasedItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
