<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProviderIDUpdate StructType
 * @subpackage Structs
 */
class ProviderIDUpdate extends AbstractStructBase
{
    /**
     * The OldProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OldProviderID;
    /**
     * The NewProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewProviderID;
    /**
     * Constructor method for ProviderIDUpdate
     * @uses ProviderIDUpdate::setOldProviderID()
     * @uses ProviderIDUpdate::setNewProviderID()
     * @param string $oldProviderID
     * @param string $newProviderID
     */
    public function __construct($oldProviderID = null, $newProviderID = null)
    {
        $this
            ->setOldProviderID($oldProviderID)
            ->setNewProviderID($newProviderID);
    }
    /**
     * Get OldProviderID value
     * @return string|null
     */
    public function getOldProviderID()
    {
        return $this->OldProviderID;
    }
    /**
     * Set OldProviderID value
     * @param string $oldProviderID
     * @return \StructType\ProviderIDUpdate
     */
    public function setOldProviderID($oldProviderID = null)
    {
        // validation for constraint: string
        if (!is_null($oldProviderID) && !is_string($oldProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oldProviderID)), __LINE__);
        }
        $this->OldProviderID = $oldProviderID;
        return $this;
    }
    /**
     * Get NewProviderID value
     * @return string|null
     */
    public function getNewProviderID()
    {
        return $this->NewProviderID;
    }
    /**
     * Set NewProviderID value
     * @param string $newProviderID
     * @return \StructType\ProviderIDUpdate
     */
    public function setNewProviderID($newProviderID = null)
    {
        // validation for constraint: string
        if (!is_null($newProviderID) && !is_string($newProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newProviderID)), __LINE__);
        }
        $this->NewProviderID = $newProviderID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProviderIDUpdate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
