<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MBRequest StructType
 * @subpackage Structs
 */
class MBRequest extends AbstractStructBase
{
    /**
     * The XMLDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $XMLDetail;
    /**
     * The PageSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PageSize;
    /**
     * The CurrentPageIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CurrentPageIndex;
    /**
     * The SourceCredentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SourceCredentials
     */
    public $SourceCredentials;
    /**
     * The UserCredentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UserCredentials
     */
    public $UserCredentials;
    /**
     * The Fields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Fields;
    /**
     * Constructor method for MBRequest
     * @uses MBRequest::setXMLDetail()
     * @uses MBRequest::setPageSize()
     * @uses MBRequest::setCurrentPageIndex()
     * @uses MBRequest::setSourceCredentials()
     * @uses MBRequest::setUserCredentials()
     * @uses MBRequest::setFields()
     * @param string $xMLDetail
     * @param int $pageSize
     * @param int $currentPageIndex
     * @param \StructType\SourceCredentials $sourceCredentials
     * @param \StructType\UserCredentials $userCredentials
     * @param \ArrayType\ArrayOfString $fields
     */
    public function __construct($xMLDetail = null, $pageSize = null, $currentPageIndex = null, \StructType\SourceCredentials $sourceCredentials = null, \StructType\UserCredentials $userCredentials = null, \ArrayType\ArrayOfString $fields = null)
    {
        $this
            ->setXMLDetail($xMLDetail)
            ->setPageSize($pageSize)
            ->setCurrentPageIndex($currentPageIndex)
            ->setSourceCredentials($sourceCredentials)
            ->setUserCredentials($userCredentials)
            ->setFields($fields);
    }
    /**
     * Get XMLDetail value
     * @return string
     */
    public function getXMLDetail()
    {
        return $this->XMLDetail;
    }
    /**
     * Set XMLDetail value
     * @uses \EnumType\XMLDetailLevel::valueIsValid()
     * @uses \EnumType\XMLDetailLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $xMLDetail
     * @return \StructType\MBRequest
     */
    public function setXMLDetail($xMLDetail = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMLDetailLevel::valueIsValid($xMLDetail)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $xMLDetail, implode(', ', \EnumType\XMLDetailLevel::getValidValues())), __LINE__);
        }
        $this->XMLDetail = $xMLDetail;
        return $this;
    }
    /**
     * Get PageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param int $pageSize
     * @return \StructType\MBRequest
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !is_numeric($pageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Get CurrentPageIndex value
     * @return int
     */
    public function getCurrentPageIndex()
    {
        return $this->CurrentPageIndex;
    }
    /**
     * Set CurrentPageIndex value
     * @param int $currentPageIndex
     * @return \StructType\MBRequest
     */
    public function setCurrentPageIndex($currentPageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($currentPageIndex) && !is_numeric($currentPageIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentPageIndex)), __LINE__);
        }
        $this->CurrentPageIndex = $currentPageIndex;
        return $this;
    }
    /**
     * Get SourceCredentials value
     * @return \StructType\SourceCredentials|null
     */
    public function getSourceCredentials()
    {
        return $this->SourceCredentials;
    }
    /**
     * Set SourceCredentials value
     * @param \StructType\SourceCredentials $sourceCredentials
     * @return \StructType\MBRequest
     */
    public function setSourceCredentials(\StructType\SourceCredentials $sourceCredentials = null)
    {
        $this->SourceCredentials = $sourceCredentials;
        return $this;
    }
    /**
     * Get UserCredentials value
     * @return \StructType\UserCredentials|null
     */
    public function getUserCredentials()
    {
        return $this->UserCredentials;
    }
    /**
     * Set UserCredentials value
     * @param \StructType\UserCredentials $userCredentials
     * @return \StructType\MBRequest
     */
    public function setUserCredentials(\StructType\UserCredentials $userCredentials = null)
    {
        $this->UserCredentials = $userCredentials;
        return $this;
    }
    /**
     * Get Fields value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getFields()
    {
        return $this->Fields;
    }
    /**
     * Set Fields value
     * @param \ArrayType\ArrayOfString $fields
     * @return \StructType\MBRequest
     */
    public function setFields(\ArrayType\ArrayOfString $fields = null)
    {
        $this->Fields = $fields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MBRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
