<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetClientServicesRequest StructType
 * @subpackage Structs
 */
class GetClientServicesRequest extends PagedBySitesMBRequest
{
    /**
     * The ClassID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ClassID;
    /**
     * The VisitCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $VisitCount;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ShowActiveOnly
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ShowActiveOnly;
    /**
     * The CrossRegionalLookup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CrossRegionalLookup;
    /**
     * The ClientID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientID;
    /**
     * The ProgramIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $ProgramIDs;
    /**
     * The SessionTypeIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $SessionTypeIDs;
    /**
     * The LocationIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $LocationIDs;
    /**
     * Constructor method for GetClientServicesRequest
     * @uses GetClientServicesRequest::setClassID()
     * @uses GetClientServicesRequest::setVisitCount()
     * @uses GetClientServicesRequest::setStartDate()
     * @uses GetClientServicesRequest::setEndDate()
     * @uses GetClientServicesRequest::setShowActiveOnly()
     * @uses GetClientServicesRequest::setCrossRegionalLookup()
     * @uses GetClientServicesRequest::setClientID()
     * @uses GetClientServicesRequest::setProgramIDs()
     * @uses GetClientServicesRequest::setSessionTypeIDs()
     * @uses GetClientServicesRequest::setLocationIDs()
     * @param int $classID
     * @param int $visitCount
     * @param string $startDate
     * @param string $endDate
     * @param bool $showActiveOnly
     * @param bool $crossRegionalLookup
     * @param string $clientID
     * @param \ArrayType\ArrayOfInt $programIDs
     * @param \ArrayType\ArrayOfInt $sessionTypeIDs
     * @param \ArrayType\ArrayOfInt $locationIDs
     */
    public function __construct($classID = null, $visitCount = null, $startDate = null, $endDate = null, $showActiveOnly = null, $crossRegionalLookup = null, $clientID = null, \ArrayType\ArrayOfInt $programIDs = null, \ArrayType\ArrayOfInt $sessionTypeIDs = null, \ArrayType\ArrayOfInt $locationIDs = null)
    {
        $this
            ->setClassID($classID)
            ->setVisitCount($visitCount)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setShowActiveOnly($showActiveOnly)
            ->setCrossRegionalLookup($crossRegionalLookup)
            ->setClientID($clientID)
            ->setProgramIDs($programIDs)
            ->setSessionTypeIDs($sessionTypeIDs)
            ->setLocationIDs($locationIDs);
    }
    /**
     * Get ClassID value
     * @return int
     */
    public function getClassID()
    {
        return $this->ClassID;
    }
    /**
     * Set ClassID value
     * @param int $classID
     * @return \StructType\GetClientServicesRequest
     */
    public function setClassID($classID = null)
    {
        // validation for constraint: int
        if (!is_null($classID) && !is_numeric($classID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($classID)), __LINE__);
        }
        $this->ClassID = $classID;
        return $this;
    }
    /**
     * Get VisitCount value
     * @return int
     */
    public function getVisitCount()
    {
        return $this->VisitCount;
    }
    /**
     * Set VisitCount value
     * @param int $visitCount
     * @return \StructType\GetClientServicesRequest
     */
    public function setVisitCount($visitCount = null)
    {
        // validation for constraint: int
        if (!is_null($visitCount) && !is_numeric($visitCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($visitCount)), __LINE__);
        }
        $this->VisitCount = $visitCount;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\GetClientServicesRequest
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\GetClientServicesRequest
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ShowActiveOnly value
     * @return bool
     */
    public function getShowActiveOnly()
    {
        return $this->ShowActiveOnly;
    }
    /**
     * Set ShowActiveOnly value
     * @param bool $showActiveOnly
     * @return \StructType\GetClientServicesRequest
     */
    public function setShowActiveOnly($showActiveOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($showActiveOnly) && !is_bool($showActiveOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($showActiveOnly)), __LINE__);
        }
        $this->ShowActiveOnly = $showActiveOnly;
        return $this;
    }
    /**
     * Get CrossRegionalLookup value
     * @return bool
     */
    public function getCrossRegionalLookup()
    {
        return $this->CrossRegionalLookup;
    }
    /**
     * Set CrossRegionalLookup value
     * @param bool $crossRegionalLookup
     * @return \StructType\GetClientServicesRequest
     */
    public function setCrossRegionalLookup($crossRegionalLookup = null)
    {
        // validation for constraint: boolean
        if (!is_null($crossRegionalLookup) && !is_bool($crossRegionalLookup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($crossRegionalLookup)), __LINE__);
        }
        $this->CrossRegionalLookup = $crossRegionalLookup;
        return $this;
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\GetClientServicesRequest
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Get ProgramIDs value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getProgramIDs()
    {
        return $this->ProgramIDs;
    }
    /**
     * Set ProgramIDs value
     * @param \ArrayType\ArrayOfInt $programIDs
     * @return \StructType\GetClientServicesRequest
     */
    public function setProgramIDs(\ArrayType\ArrayOfInt $programIDs = null)
    {
        $this->ProgramIDs = $programIDs;
        return $this;
    }
    /**
     * Get SessionTypeIDs value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getSessionTypeIDs()
    {
        return $this->SessionTypeIDs;
    }
    /**
     * Set SessionTypeIDs value
     * @param \ArrayType\ArrayOfInt $sessionTypeIDs
     * @return \StructType\GetClientServicesRequest
     */
    public function setSessionTypeIDs(\ArrayType\ArrayOfInt $sessionTypeIDs = null)
    {
        $this->SessionTypeIDs = $sessionTypeIDs;
        return $this;
    }
    /**
     * Get LocationIDs value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getLocationIDs()
    {
        return $this->LocationIDs;
    }
    /**
     * Set LocationIDs value
     * @param \ArrayType\ArrayOfInt $locationIDs
     * @return \StructType\GetClientServicesRequest
     */
    public function setLocationIDs(\ArrayType\ArrayOfInt $locationIDs = null)
    {
        $this->LocationIDs = $locationIDs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetClientServicesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
