<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetClientFormulaNotesRequest StructType
 * @subpackage Structs
 */
class GetClientFormulaNotesRequest extends MBRequest
{
    /**
     * The AppointmentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AppointmentID;
    /**
     * The ClientID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientID;
    /**
     * Constructor method for GetClientFormulaNotesRequest
     * @uses GetClientFormulaNotesRequest::setAppointmentID()
     * @uses GetClientFormulaNotesRequest::setClientID()
     * @param int $appointmentID
     * @param string $clientID
     */
    public function __construct($appointmentID = null, $clientID = null)
    {
        $this
            ->setAppointmentID($appointmentID)
            ->setClientID($clientID);
    }
    /**
     * Get AppointmentID value
     * @return int
     */
    public function getAppointmentID()
    {
        return $this->AppointmentID;
    }
    /**
     * Set AppointmentID value
     * @param int $appointmentID
     * @return \StructType\GetClientFormulaNotesRequest
     */
    public function setAppointmentID($appointmentID = null)
    {
        // validation for constraint: int
        if (!is_null($appointmentID) && !is_numeric($appointmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($appointmentID)), __LINE__);
        }
        $this->AppointmentID = $appointmentID;
        return $this;
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\GetClientFormulaNotesRequest
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetClientFormulaNotesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
