<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormulaNote StructType
 * @subpackage Structs
 */
class FormulaNote extends MBObject
{
    /**
     * The EntryDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EntryDateTime;
    /**
     * The AppointmentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AppointmentID;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The ClientID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientID;
    /**
     * The Note
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note;
    /**
     * Constructor method for FormulaNote
     * @uses FormulaNote::setEntryDateTime()
     * @uses FormulaNote::setAppointmentID()
     * @uses FormulaNote::setID()
     * @uses FormulaNote::setClientID()
     * @uses FormulaNote::setNote()
     * @param string $entryDateTime
     * @param int $appointmentID
     * @param int $iD
     * @param string $clientID
     * @param string $note
     */
    public function __construct($entryDateTime = null, $appointmentID = null, $iD = null, $clientID = null, $note = null)
    {
        $this
            ->setEntryDateTime($entryDateTime)
            ->setAppointmentID($appointmentID)
            ->setID($iD)
            ->setClientID($clientID)
            ->setNote($note);
    }
    /**
     * Get EntryDateTime value
     * @return string
     */
    public function getEntryDateTime()
    {
        return $this->EntryDateTime;
    }
    /**
     * Set EntryDateTime value
     * @param string $entryDateTime
     * @return \StructType\FormulaNote
     */
    public function setEntryDateTime($entryDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($entryDateTime) && !is_string($entryDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entryDateTime)), __LINE__);
        }
        $this->EntryDateTime = $entryDateTime;
        return $this;
    }
    /**
     * Get AppointmentID value
     * @return int
     */
    public function getAppointmentID()
    {
        return $this->AppointmentID;
    }
    /**
     * Set AppointmentID value
     * @param int $appointmentID
     * @return \StructType\FormulaNote
     */
    public function setAppointmentID($appointmentID = null)
    {
        // validation for constraint: int
        if (!is_null($appointmentID) && !is_numeric($appointmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($appointmentID)), __LINE__);
        }
        $this->AppointmentID = $appointmentID;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\FormulaNote
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\FormulaNote
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \StructType\FormulaNote
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FormulaNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
