<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientSendUserNewPasswordRequest StructType
 * @subpackage Structs
 */
class ClientSendUserNewPasswordRequest extends MBRequest
{
    /**
     * The UserEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserEmail;
    /**
     * The UserFirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserFirstName;
    /**
     * The UserLastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserLastName;
    /**
     * Constructor method for ClientSendUserNewPasswordRequest
     * @uses ClientSendUserNewPasswordRequest::setUserEmail()
     * @uses ClientSendUserNewPasswordRequest::setUserFirstName()
     * @uses ClientSendUserNewPasswordRequest::setUserLastName()
     * @param string $userEmail
     * @param string $userFirstName
     * @param string $userLastName
     */
    public function __construct($userEmail = null, $userFirstName = null, $userLastName = null)
    {
        $this
            ->setUserEmail($userEmail)
            ->setUserFirstName($userFirstName)
            ->setUserLastName($userLastName);
    }
    /**
     * Get UserEmail value
     * @return string|null
     */
    public function getUserEmail()
    {
        return $this->UserEmail;
    }
    /**
     * Set UserEmail value
     * @param string $userEmail
     * @return \StructType\ClientSendUserNewPasswordRequest
     */
    public function setUserEmail($userEmail = null)
    {
        // validation for constraint: string
        if (!is_null($userEmail) && !is_string($userEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userEmail)), __LINE__);
        }
        $this->UserEmail = $userEmail;
        return $this;
    }
    /**
     * Get UserFirstName value
     * @return string|null
     */
    public function getUserFirstName()
    {
        return $this->UserFirstName;
    }
    /**
     * Set UserFirstName value
     * @param string $userFirstName
     * @return \StructType\ClientSendUserNewPasswordRequest
     */
    public function setUserFirstName($userFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($userFirstName) && !is_string($userFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userFirstName)), __LINE__);
        }
        $this->UserFirstName = $userFirstName;
        return $this;
    }
    /**
     * Get UserLastName value
     * @return string|null
     */
    public function getUserLastName()
    {
        return $this->UserLastName;
    }
    /**
     * Set UserLastName value
     * @param string $userLastName
     * @return \StructType\ClientSendUserNewPasswordRequest
     */
    public function setUserLastName($userLastName = null)
    {
        // validation for constraint: string
        if (!is_null($userLastName) && !is_string($userLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLastName)), __LINE__);
        }
        $this->UserLastName = $userLastName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClientSendUserNewPasswordRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
