<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientContract StructType
 * @subpackage Structs
 */
class ClientContract extends MBObject
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ID;
    /**
     * The SiteID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SiteID;
    /**
     * The AgreementDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AgreementDate;
    /**
     * The OriginationLocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OriginationLocationID;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The AutopayStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AutopayStatus;
    /**
     * The ContractName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContractName;
    /**
     * The UpcomingAutopayEvents
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfUpcomingAutopayEvent
     */
    public $UpcomingAutopayEvents;
    /**
     * Constructor method for ClientContract
     * @uses ClientContract::setID()
     * @uses ClientContract::setSiteID()
     * @uses ClientContract::setAgreementDate()
     * @uses ClientContract::setOriginationLocationID()
     * @uses ClientContract::setStartDate()
     * @uses ClientContract::setEndDate()
     * @uses ClientContract::setAutopayStatus()
     * @uses ClientContract::setContractName()
     * @uses ClientContract::setUpcomingAutopayEvents()
     * @param int $iD
     * @param int $siteID
     * @param string $agreementDate
     * @param int $originationLocationID
     * @param string $startDate
     * @param string $endDate
     * @param string $autopayStatus
     * @param string $contractName
     * @param \ArrayType\ArrayOfUpcomingAutopayEvent $upcomingAutopayEvents
     */
    public function __construct($iD = null, $siteID = null, $agreementDate = null, $originationLocationID = null, $startDate = null, $endDate = null, $autopayStatus = null, $contractName = null, \ArrayType\ArrayOfUpcomingAutopayEvent $upcomingAutopayEvents = null)
    {
        $this
            ->setID($iD)
            ->setSiteID($siteID)
            ->setAgreementDate($agreementDate)
            ->setOriginationLocationID($originationLocationID)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setAutopayStatus($autopayStatus)
            ->setContractName($contractName)
            ->setUpcomingAutopayEvents($upcomingAutopayEvents);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\ClientContract
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get SiteID value
     * @return int
     */
    public function getSiteID()
    {
        return $this->SiteID;
    }
    /**
     * Set SiteID value
     * @param int $siteID
     * @return \StructType\ClientContract
     */
    public function setSiteID($siteID = null)
    {
        // validation for constraint: int
        if (!is_null($siteID) && !is_numeric($siteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($siteID)), __LINE__);
        }
        $this->SiteID = $siteID;
        return $this;
    }
    /**
     * Get AgreementDate value
     * @return string
     */
    public function getAgreementDate()
    {
        return $this->AgreementDate;
    }
    /**
     * Set AgreementDate value
     * @param string $agreementDate
     * @return \StructType\ClientContract
     */
    public function setAgreementDate($agreementDate = null)
    {
        // validation for constraint: string
        if (!is_null($agreementDate) && !is_string($agreementDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agreementDate)), __LINE__);
        }
        $this->AgreementDate = $agreementDate;
        return $this;
    }
    /**
     * Get OriginationLocationID value
     * @return int
     */
    public function getOriginationLocationID()
    {
        return $this->OriginationLocationID;
    }
    /**
     * Set OriginationLocationID value
     * @param int $originationLocationID
     * @return \StructType\ClientContract
     */
    public function setOriginationLocationID($originationLocationID = null)
    {
        // validation for constraint: int
        if (!is_null($originationLocationID) && !is_numeric($originationLocationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($originationLocationID)), __LINE__);
        }
        $this->OriginationLocationID = $originationLocationID;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\ClientContract
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\ClientContract
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get AutopayStatus value
     * @return string
     */
    public function getAutopayStatus()
    {
        return $this->AutopayStatus;
    }
    /**
     * Set AutopayStatus value
     * @uses \EnumType\EAutopayStatus::valueIsValid()
     * @uses \EnumType\EAutopayStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $autopayStatus
     * @return \StructType\ClientContract
     */
    public function setAutopayStatus($autopayStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EAutopayStatus::valueIsValid($autopayStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $autopayStatus, implode(', ', \EnumType\EAutopayStatus::getValidValues())), __LINE__);
        }
        $this->AutopayStatus = $autopayStatus;
        return $this;
    }
    /**
     * Get ContractName value
     * @return string|null
     */
    public function getContractName()
    {
        return $this->ContractName;
    }
    /**
     * Set ContractName value
     * @param string $contractName
     * @return \StructType\ClientContract
     */
    public function setContractName($contractName = null)
    {
        // validation for constraint: string
        if (!is_null($contractName) && !is_string($contractName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractName)), __LINE__);
        }
        $this->ContractName = $contractName;
        return $this;
    }
    /**
     * Get UpcomingAutopayEvents value
     * @return \ArrayType\ArrayOfUpcomingAutopayEvent|null
     */
    public function getUpcomingAutopayEvents()
    {
        return $this->UpcomingAutopayEvents;
    }
    /**
     * Set UpcomingAutopayEvents value
     * @param \ArrayType\ArrayOfUpcomingAutopayEvent $upcomingAutopayEvents
     * @return \StructType\ClientContract
     */
    public function setUpcomingAutopayEvents(\ArrayType\ArrayOfUpcomingAutopayEvent $upcomingAutopayEvents = null)
    {
        $this->UpcomingAutopayEvents = $upcomingAutopayEvents;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClientContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
