<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Availability StructType
 * @subpackage Structs
 */
class Availability extends ScheduleItem
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The StartDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDateTime;
    /**
     * The EndDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDateTime;
    /**
     * The BookableEndDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BookableEndDateTime;
    /**
     * The Staff
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Staff
     */
    public $Staff;
    /**
     * The SessionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SessionType
     */
    public $SessionType;
    /**
     * The Programs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProgram
     */
    public $Programs;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Location
     */
    public $Location;
    /**
     * Constructor method for Availability
     * @uses Availability::setID()
     * @uses Availability::setStartDateTime()
     * @uses Availability::setEndDateTime()
     * @uses Availability::setBookableEndDateTime()
     * @uses Availability::setStaff()
     * @uses Availability::setSessionType()
     * @uses Availability::setPrograms()
     * @uses Availability::setLocation()
     * @param int $iD
     * @param string $startDateTime
     * @param string $endDateTime
     * @param string $bookableEndDateTime
     * @param \StructType\Staff $staff
     * @param \StructType\SessionType $sessionType
     * @param \ArrayType\ArrayOfProgram $programs
     * @param \StructType\Location $location
     */
    public function __construct($iD = null, $startDateTime = null, $endDateTime = null, $bookableEndDateTime = null, \StructType\Staff $staff = null, \StructType\SessionType $sessionType = null, \ArrayType\ArrayOfProgram $programs = null, \StructType\Location $location = null)
    {
        $this
            ->setID($iD)
            ->setStartDateTime($startDateTime)
            ->setEndDateTime($endDateTime)
            ->setBookableEndDateTime($bookableEndDateTime)
            ->setStaff($staff)
            ->setSessionType($sessionType)
            ->setPrograms($programs)
            ->setLocation($location);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Availability
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get StartDateTime value
     * @return string
     */
    public function getStartDateTime()
    {
        return $this->StartDateTime;
    }
    /**
     * Set StartDateTime value
     * @param string $startDateTime
     * @return \StructType\Availability
     */
    public function setStartDateTime($startDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTime) && !is_string($startDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDateTime)), __LINE__);
        }
        $this->StartDateTime = $startDateTime;
        return $this;
    }
    /**
     * Get EndDateTime value
     * @return string
     */
    public function getEndDateTime()
    {
        return $this->EndDateTime;
    }
    /**
     * Set EndDateTime value
     * @param string $endDateTime
     * @return \StructType\Availability
     */
    public function setEndDateTime($endDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($endDateTime) && !is_string($endDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDateTime)), __LINE__);
        }
        $this->EndDateTime = $endDateTime;
        return $this;
    }
    /**
     * Get BookableEndDateTime value
     * @return string
     */
    public function getBookableEndDateTime()
    {
        return $this->BookableEndDateTime;
    }
    /**
     * Set BookableEndDateTime value
     * @param string $bookableEndDateTime
     * @return \StructType\Availability
     */
    public function setBookableEndDateTime($bookableEndDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($bookableEndDateTime) && !is_string($bookableEndDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookableEndDateTime)), __LINE__);
        }
        $this->BookableEndDateTime = $bookableEndDateTime;
        return $this;
    }
    /**
     * Get Staff value
     * @return \StructType\Staff|null
     */
    public function getStaff()
    {
        return $this->Staff;
    }
    /**
     * Set Staff value
     * @param \StructType\Staff $staff
     * @return \StructType\Availability
     */
    public function setStaff(\StructType\Staff $staff = null)
    {
        $this->Staff = $staff;
        return $this;
    }
    /**
     * Get SessionType value
     * @return \StructType\SessionType|null
     */
    public function getSessionType()
    {
        return $this->SessionType;
    }
    /**
     * Set SessionType value
     * @param \StructType\SessionType $sessionType
     * @return \StructType\Availability
     */
    public function setSessionType(\StructType\SessionType $sessionType = null)
    {
        $this->SessionType = $sessionType;
        return $this;
    }
    /**
     * Get Programs value
     * @return \ArrayType\ArrayOfProgram|null
     */
    public function getPrograms()
    {
        return $this->Programs;
    }
    /**
     * Set Programs value
     * @param \ArrayType\ArrayOfProgram $programs
     * @return \StructType\Availability
     */
    public function setPrograms(\ArrayType\ArrayOfProgram $programs = null)
    {
        $this->Programs = $programs;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Location|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\Location $location
     * @return \StructType\Availability
     */
    public function setLocation(\StructType\Location $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Availability
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
