<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upload ServiceType
 * @subpackage Services
 */
class Upload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UploadClientDocument
     * Meta informations extracted from the WSDL
     * - documentation: Upload a client document.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadClientDocument $parameters
     * @return \StructType\UploadClientDocumentResponse|bool
     */
    public function UploadClientDocument(\StructType\UploadClientDocument $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UploadClientDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadClientPhoto
     * Meta informations extracted from the WSDL
     * - documentation: Upload a client photo.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadClientPhoto $parameters
     * @return \StructType\UploadClientPhotoResponse|bool
     */
    public function UploadClientPhoto(\StructType\UploadClientPhoto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UploadClientPhoto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UploadClientDocumentResponse|\StructType\UploadClientPhotoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
