<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddArrival
     * Meta informations extracted from the WSDL
     * - documentation: Adds an arrival record for the given client.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddArrival $parameters
     * @return \StructType\AddArrivalResponse|bool
     */
    public function AddArrival(\StructType\AddArrival $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddArrival($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddOrUpdateClients
     * Meta informations extracted from the WSDL
     * - documentation: Adds or updates information for a list of clients.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddOrUpdateClients $parameters
     * @return \StructType\AddOrUpdateClientsResponse|bool
     */
    public function AddOrUpdateClients(\StructType\AddOrUpdateClients $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddOrUpdateClients($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddOrUpdateContactLogs
     * Meta informations extracted from the WSDL
     * - documentation: Add or update client contact logs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddOrUpdateContactLogs $parameters
     * @return \StructType\AddOrUpdateContactLogsResponse|bool
     */
    public function AddOrUpdateContactLogs(\StructType\AddOrUpdateContactLogs $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddOrUpdateContactLogs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddClientFormulaNote
     * Meta informations extracted from the WSDL
     * - documentation: Adds a formula note to a client.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddClientFormulaNote $parameters
     * @return \StructType\AddClientFormulaNoteResponse|bool
     */
    public function AddClientFormulaNote(\StructType\AddClientFormulaNote $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddClientFormulaNote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddArrivalResponse|\StructType\AddClientFormulaNoteResponse|\StructType\AddOrUpdateClientsResponse|\StructType\AddOrUpdateContactLogsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
