<?php

namespace EnumType;

/**
 * This class stands for StatusCode EnumType
 * @subpackage Enumerations
 */
class StatusCode
{
    /**
     * Constant for value 'Success'
     * @return string 'Success'
     */
    const VALUE_SUCCESS = 'Success';
    /**
     * Constant for value 'InvalidCredentials'
     * @return string 'InvalidCredentials'
     */
    const VALUE_INVALID_CREDENTIALS = 'InvalidCredentials';
    /**
     * Constant for value 'InvalidParameters'
     * @return string 'InvalidParameters'
     */
    const VALUE_INVALID_PARAMETERS = 'InvalidParameters';
    /**
     * Constant for value 'InternalException'
     * @return string 'InternalException'
     */
    const VALUE_INTERNAL_EXCEPTION = 'InternalException';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'FailedAction'
     * @return string 'FailedAction'
     */
    const VALUE_FAILED_ACTION = 'FailedAction';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_INVALID_CREDENTIALS
     * @uses self::VALUE_INVALID_PARAMETERS
     * @uses self::VALUE_INTERNAL_EXCEPTION
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_FAILED_ACTION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUCCESS,
            self::VALUE_INVALID_CREDENTIALS,
            self::VALUE_INVALID_PARAMETERS,
            self::VALUE_INTERNAL_EXCEPTION,
            self::VALUE_UNKNOWN,
            self::VALUE_FAILED_ACTION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
