<?php

namespace EnumType;

/**
 * This class stands for EPaymentMethod EnumType
 * @subpackage Enumerations
 */
class EPaymentMethod
{
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'CreditCard'
     * @return string 'CreditCard'
     */
    const VALUE_CREDIT_CARD = 'CreditCard';
    /**
     * Constant for value 'DebitAccount'
     * @return string 'DebitAccount'
     */
    const VALUE_DEBIT_ACCOUNT = 'DebitAccount';
    /**
     * Constant for value 'ACH'
     * @return string 'ACH'
     */
    const VALUE_ACH = 'ACH';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_CREDIT_CARD
     * @uses self::VALUE_DEBIT_ACCOUNT
     * @uses self::VALUE_ACH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OTHER,
            self::VALUE_CREDIT_CARD,
            self::VALUE_DEBIT_ACCOUNT,
            self::VALUE_ACH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
