<?php

namespace EnumType;

/**
 * This class stands for ActionCode EnumType
 * @subpackage Enumerations
 */
class ActionCode
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Added'
     * @return string 'Added'
     */
    const VALUE_ADDED = 'Added';
    /**
     * Constant for value 'Updated'
     * @return string 'Updated'
     */
    const VALUE_UPDATED = 'Updated';
    /**
     * Constant for value 'Failed'
     * @return string 'Failed'
     */
    const VALUE_FAILED = 'Failed';
    /**
     * Constant for value 'Removed'
     * @return string 'Removed'
     */
    const VALUE_REMOVED = 'Removed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_ADDED
     * @uses self::VALUE_UPDATED
     * @uses self::VALUE_FAILED
     * @uses self::VALUE_REMOVED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_ADDED,
            self::VALUE_UPDATED,
            self::VALUE_FAILED,
            self::VALUE_REMOVED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
