<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUnavailability ArrayType
 * @subpackage Arrays
 */
class ArrayOfUnavailability extends AbstractStructArrayBase
{
    /**
     * The Unavailability
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Unavailability[]
     */
    public $Unavailability;
    /**
     * Constructor method for ArrayOfUnavailability
     * @uses ArrayOfUnavailability::setUnavailability()
     * @param \StructType\Unavailability[] $unavailability
     */
    public function __construct(array $unavailability = array())
    {
        $this
            ->setUnavailability($unavailability);
    }
    /**
     * Get Unavailability value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Unavailability[]|null
     */
    public function getUnavailability()
    {
        return isset($this->Unavailability) ? $this->Unavailability : null;
    }
    /**
     * Set Unavailability value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Unavailability[] $unavailability
     * @return \ArrayType\ArrayOfUnavailability
     */
    public function setUnavailability(array $unavailability = array())
    {
        foreach ($unavailability as $arrayOfUnavailabilityUnavailabilityItem) {
            // validation for constraint: itemType
            if (!$arrayOfUnavailabilityUnavailabilityItem instanceof \StructType\Unavailability) {
                throw new \InvalidArgumentException(sprintf('The Unavailability property can only contain items of \StructType\Unavailability, "%s" given', is_object($arrayOfUnavailabilityUnavailabilityItem) ? get_class($arrayOfUnavailabilityUnavailabilityItem) : gettype($arrayOfUnavailabilityUnavailabilityItem)), __LINE__);
            }
        }
        if (is_null($unavailability) || (is_array($unavailability) && empty($unavailability))) {
            unset($this->Unavailability);
        } else {
            $this->Unavailability = $unavailability;
        }
        return $this;
    }
    /**
     * Add item to Unavailability value
     * @throws \InvalidArgumentException
     * @param \StructType\Unavailability $item
     * @return \ArrayType\ArrayOfUnavailability
     */
    public function addToUnavailability(\StructType\Unavailability $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unavailability) {
            throw new \InvalidArgumentException(sprintf('The Unavailability property can only contain items of \StructType\Unavailability, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Unavailability[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Unavailability|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Unavailability|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Unavailability|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Unavailability|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Unavailability|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Unavailability
     */
    public function getAttributeName()
    {
        return 'Unavailability';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfUnavailability
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
