<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSalesRep ArrayType
 * @subpackage Arrays
 */
class ArrayOfSalesRep extends AbstractStructArrayBase
{
    /**
     * The SalesRep
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SalesRep[]
     */
    public $SalesRep;
    /**
     * Constructor method for ArrayOfSalesRep
     * @uses ArrayOfSalesRep::setSalesRep()
     * @param \StructType\SalesRep[] $salesRep
     */
    public function __construct(array $salesRep = array())
    {
        $this
            ->setSalesRep($salesRep);
    }
    /**
     * Get SalesRep value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SalesRep[]|null
     */
    public function getSalesRep()
    {
        return isset($this->SalesRep) ? $this->SalesRep : null;
    }
    /**
     * Set SalesRep value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SalesRep[] $salesRep
     * @return \ArrayType\ArrayOfSalesRep
     */
    public function setSalesRep(array $salesRep = array())
    {
        foreach ($salesRep as $arrayOfSalesRepSalesRepItem) {
            // validation for constraint: itemType
            if (!$arrayOfSalesRepSalesRepItem instanceof \StructType\SalesRep) {
                throw new \InvalidArgumentException(sprintf('The SalesRep property can only contain items of \StructType\SalesRep, "%s" given', is_object($arrayOfSalesRepSalesRepItem) ? get_class($arrayOfSalesRepSalesRepItem) : gettype($arrayOfSalesRepSalesRepItem)), __LINE__);
            }
        }
        if (is_null($salesRep) || (is_array($salesRep) && empty($salesRep))) {
            unset($this->SalesRep);
        } else {
            $this->SalesRep = $salesRep;
        }
        return $this;
    }
    /**
     * Add item to SalesRep value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesRep $item
     * @return \ArrayType\ArrayOfSalesRep
     */
    public function addToSalesRep(\StructType\SalesRep $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SalesRep) {
            throw new \InvalidArgumentException(sprintf('The SalesRep property can only contain items of \StructType\SalesRep, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SalesRep[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SalesRep|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SalesRep|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SalesRep|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SalesRep|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SalesRep|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SalesRep
     */
    public function getAttributeName()
    {
        return 'SalesRep';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSalesRep
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
