<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFormulaNote ArrayType
 * @subpackage Arrays
 */
class ArrayOfFormulaNote extends AbstractStructArrayBase
{
    /**
     * The FormulaNote
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FormulaNote[]
     */
    public $FormulaNote;
    /**
     * Constructor method for ArrayOfFormulaNote
     * @uses ArrayOfFormulaNote::setFormulaNote()
     * @param \StructType\FormulaNote[] $formulaNote
     */
    public function __construct(array $formulaNote = array())
    {
        $this
            ->setFormulaNote($formulaNote);
    }
    /**
     * Get FormulaNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FormulaNote[]|null
     */
    public function getFormulaNote()
    {
        return isset($this->FormulaNote) ? $this->FormulaNote : null;
    }
    /**
     * Set FormulaNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FormulaNote[] $formulaNote
     * @return \ArrayType\ArrayOfFormulaNote
     */
    public function setFormulaNote(array $formulaNote = array())
    {
        foreach ($formulaNote as $arrayOfFormulaNoteFormulaNoteItem) {
            // validation for constraint: itemType
            if (!$arrayOfFormulaNoteFormulaNoteItem instanceof \StructType\FormulaNote) {
                throw new \InvalidArgumentException(sprintf('The FormulaNote property can only contain items of \StructType\FormulaNote, "%s" given', is_object($arrayOfFormulaNoteFormulaNoteItem) ? get_class($arrayOfFormulaNoteFormulaNoteItem) : gettype($arrayOfFormulaNoteFormulaNoteItem)), __LINE__);
            }
        }
        if (is_null($formulaNote) || (is_array($formulaNote) && empty($formulaNote))) {
            unset($this->FormulaNote);
        } else {
            $this->FormulaNote = $formulaNote;
        }
        return $this;
    }
    /**
     * Add item to FormulaNote value
     * @throws \InvalidArgumentException
     * @param \StructType\FormulaNote $item
     * @return \ArrayType\ArrayOfFormulaNote
     */
    public function addToFormulaNote(\StructType\FormulaNote $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FormulaNote) {
            throw new \InvalidArgumentException(sprintf('The FormulaNote property can only contain items of \StructType\FormulaNote, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FormulaNote[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FormulaNote|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FormulaNote|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FormulaNote|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FormulaNote|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FormulaNote|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FormulaNote
     */
    public function getAttributeName()
    {
        return 'FormulaNote';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfFormulaNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
