<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomClientField ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomClientField extends AbstractStructArrayBase
{
    /**
     * The CustomClientField
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomClientField[]
     */
    public $CustomClientField;
    /**
     * Constructor method for ArrayOfCustomClientField
     * @uses ArrayOfCustomClientField::setCustomClientField()
     * @param \StructType\CustomClientField[] $customClientField
     */
    public function __construct(array $customClientField = array())
    {
        $this
            ->setCustomClientField($customClientField);
    }
    /**
     * Get CustomClientField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomClientField[]|null
     */
    public function getCustomClientField()
    {
        return isset($this->CustomClientField) ? $this->CustomClientField : null;
    }
    /**
     * Set CustomClientField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomClientField[] $customClientField
     * @return \ArrayType\ArrayOfCustomClientField
     */
    public function setCustomClientField(array $customClientField = array())
    {
        foreach ($customClientField as $arrayOfCustomClientFieldCustomClientFieldItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomClientFieldCustomClientFieldItem instanceof \StructType\CustomClientField) {
                throw new \InvalidArgumentException(sprintf('The CustomClientField property can only contain items of \StructType\CustomClientField, "%s" given', is_object($arrayOfCustomClientFieldCustomClientFieldItem) ? get_class($arrayOfCustomClientFieldCustomClientFieldItem) : gettype($arrayOfCustomClientFieldCustomClientFieldItem)), __LINE__);
            }
        }
        if (is_null($customClientField) || (is_array($customClientField) && empty($customClientField))) {
            unset($this->CustomClientField);
        } else {
            $this->CustomClientField = $customClientField;
        }
        return $this;
    }
    /**
     * Add item to CustomClientField value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomClientField $item
     * @return \ArrayType\ArrayOfCustomClientField
     */
    public function addToCustomClientField(\StructType\CustomClientField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomClientField) {
            throw new \InvalidArgumentException(sprintf('The CustomClientField property can only contain items of \StructType\CustomClientField, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomClientField[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomClientField|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomClientField|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomClientField|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomClientField|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomClientField|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomClientField
     */
    public function getAttributeName()
    {
        return 'CustomClientField';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCustomClientField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
