<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContactLog ArrayType
 * @subpackage Arrays
 */
class ArrayOfContactLog extends AbstractStructArrayBase
{
    /**
     * The ContactLog
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactLog[]
     */
    public $ContactLog;
    /**
     * Constructor method for ArrayOfContactLog
     * @uses ArrayOfContactLog::setContactLog()
     * @param \StructType\ContactLog[] $contactLog
     */
    public function __construct(array $contactLog = array())
    {
        $this
            ->setContactLog($contactLog);
    }
    /**
     * Get ContactLog value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactLog[]|null
     */
    public function getContactLog()
    {
        return isset($this->ContactLog) ? $this->ContactLog : null;
    }
    /**
     * Set ContactLog value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContactLog[] $contactLog
     * @return \ArrayType\ArrayOfContactLog
     */
    public function setContactLog(array $contactLog = array())
    {
        foreach ($contactLog as $arrayOfContactLogContactLogItem) {
            // validation for constraint: itemType
            if (!$arrayOfContactLogContactLogItem instanceof \StructType\ContactLog) {
                throw new \InvalidArgumentException(sprintf('The ContactLog property can only contain items of \StructType\ContactLog, "%s" given', is_object($arrayOfContactLogContactLogItem) ? get_class($arrayOfContactLogContactLogItem) : gettype($arrayOfContactLogContactLogItem)), __LINE__);
            }
        }
        if (is_null($contactLog) || (is_array($contactLog) && empty($contactLog))) {
            unset($this->ContactLog);
        } else {
            $this->ContactLog = $contactLog;
        }
        return $this;
    }
    /**
     * Add item to ContactLog value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactLog $item
     * @return \ArrayType\ArrayOfContactLog
     */
    public function addToContactLog(\StructType\ContactLog $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactLog) {
            throw new \InvalidArgumentException(sprintf('The ContactLog property can only contain items of \StructType\ContactLog, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactLog[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ContactLog|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ContactLog|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ContactLog|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ContactLog|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ContactLog|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContactLog
     */
    public function getAttributeName()
    {
        return 'ContactLog';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfContactLog
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
