<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClientRelationship ArrayType
 * @subpackage Arrays
 */
class ArrayOfClientRelationship extends AbstractStructArrayBase
{
    /**
     * The ClientRelationship
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClientRelationship[]
     */
    public $ClientRelationship;
    /**
     * Constructor method for ArrayOfClientRelationship
     * @uses ArrayOfClientRelationship::setClientRelationship()
     * @param \StructType\ClientRelationship[] $clientRelationship
     */
    public function __construct(array $clientRelationship = array())
    {
        $this
            ->setClientRelationship($clientRelationship);
    }
    /**
     * Get ClientRelationship value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClientRelationship[]|null
     */
    public function getClientRelationship()
    {
        return isset($this->ClientRelationship) ? $this->ClientRelationship : null;
    }
    /**
     * Set ClientRelationship value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClientRelationship[] $clientRelationship
     * @return \ArrayType\ArrayOfClientRelationship
     */
    public function setClientRelationship(array $clientRelationship = array())
    {
        foreach ($clientRelationship as $arrayOfClientRelationshipClientRelationshipItem) {
            // validation for constraint: itemType
            if (!$arrayOfClientRelationshipClientRelationshipItem instanceof \StructType\ClientRelationship) {
                throw new \InvalidArgumentException(sprintf('The ClientRelationship property can only contain items of \StructType\ClientRelationship, "%s" given', is_object($arrayOfClientRelationshipClientRelationshipItem) ? get_class($arrayOfClientRelationshipClientRelationshipItem) : gettype($arrayOfClientRelationshipClientRelationshipItem)), __LINE__);
            }
        }
        if (is_null($clientRelationship) || (is_array($clientRelationship) && empty($clientRelationship))) {
            unset($this->ClientRelationship);
        } else {
            $this->ClientRelationship = $clientRelationship;
        }
        return $this;
    }
    /**
     * Add item to ClientRelationship value
     * @throws \InvalidArgumentException
     * @param \StructType\ClientRelationship $item
     * @return \ArrayType\ArrayOfClientRelationship
     */
    public function addToClientRelationship(\StructType\ClientRelationship $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ClientRelationship) {
            throw new \InvalidArgumentException(sprintf('The ClientRelationship property can only contain items of \StructType\ClientRelationship, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ClientRelationship[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ClientRelationship|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ClientRelationship|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ClientRelationship|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ClientRelationship|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ClientRelationship|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ClientRelationship
     */
    public function getAttributeName()
    {
        return 'ClientRelationship';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfClientRelationship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
