<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClientIndex ArrayType
 * @subpackage Arrays
 */
class ArrayOfClientIndex extends AbstractStructArrayBase
{
    /**
     * The ClientIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClientIndex[]
     */
    public $ClientIndex;
    /**
     * Constructor method for ArrayOfClientIndex
     * @uses ArrayOfClientIndex::setClientIndex()
     * @param \StructType\ClientIndex[] $clientIndex
     */
    public function __construct(array $clientIndex = array())
    {
        $this
            ->setClientIndex($clientIndex);
    }
    /**
     * Get ClientIndex value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClientIndex[]|null
     */
    public function getClientIndex()
    {
        return isset($this->ClientIndex) ? $this->ClientIndex : null;
    }
    /**
     * Set ClientIndex value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClientIndex[] $clientIndex
     * @return \ArrayType\ArrayOfClientIndex
     */
    public function setClientIndex(array $clientIndex = array())
    {
        foreach ($clientIndex as $arrayOfClientIndexClientIndexItem) {
            // validation for constraint: itemType
            if (!$arrayOfClientIndexClientIndexItem instanceof \StructType\ClientIndex) {
                throw new \InvalidArgumentException(sprintf('The ClientIndex property can only contain items of \StructType\ClientIndex, "%s" given', is_object($arrayOfClientIndexClientIndexItem) ? get_class($arrayOfClientIndexClientIndexItem) : gettype($arrayOfClientIndexClientIndexItem)), __LINE__);
            }
        }
        if (is_null($clientIndex) || (is_array($clientIndex) && empty($clientIndex))) {
            unset($this->ClientIndex);
        } else {
            $this->ClientIndex = $clientIndex;
        }
        return $this;
    }
    /**
     * Add item to ClientIndex value
     * @throws \InvalidArgumentException
     * @param \StructType\ClientIndex $item
     * @return \ArrayType\ArrayOfClientIndex
     */
    public function addToClientIndex(\StructType\ClientIndex $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ClientIndex) {
            throw new \InvalidArgumentException(sprintf('The ClientIndex property can only contain items of \StructType\ClientIndex, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ClientIndex[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ClientIndex|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ClientIndex|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ClientIndex|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ClientIndex|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ClientIndex|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ClientIndex
     */
    public function getAttributeName()
    {
        return 'ClientIndex';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfClientIndex
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
