<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClient ArrayType
 * @subpackage Arrays
 */
class ArrayOfClient extends AbstractStructArrayBase
{
    /**
     * The Client
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Client[]
     */
    public $Client;
    /**
     * Constructor method for ArrayOfClient
     * @uses ArrayOfClient::setClient()
     * @param \StructType\Client[] $client
     */
    public function __construct(array $client = array())
    {
        $this
            ->setClient($client);
    }
    /**
     * Get Client value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Client[]|null
     */
    public function getClient()
    {
        return isset($this->Client) ? $this->Client : null;
    }
    /**
     * Set Client value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Client[] $client
     * @return \ArrayType\ArrayOfClient
     */
    public function setClient(array $client = array())
    {
        foreach ($client as $arrayOfClientClientItem) {
            // validation for constraint: itemType
            if (!$arrayOfClientClientItem instanceof \StructType\Client) {
                throw new \InvalidArgumentException(sprintf('The Client property can only contain items of \StructType\Client, "%s" given', is_object($arrayOfClientClientItem) ? get_class($arrayOfClientClientItem) : gettype($arrayOfClientClientItem)), __LINE__);
            }
        }
        if (is_null($client) || (is_array($client) && empty($client))) {
            unset($this->Client);
        } else {
            $this->Client = $client;
        }
        return $this;
    }
    /**
     * Add item to Client value
     * @throws \InvalidArgumentException
     * @param \StructType\Client $item
     * @return \ArrayType\ArrayOfClient
     */
    public function addToClient(\StructType\Client $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Client) {
            throw new \InvalidArgumentException(sprintf('The Client property can only contain items of \StructType\Client, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Client[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Client|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Client|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Client|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Client|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Client|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Client
     */
    public function getAttributeName()
    {
        return 'Client';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfClient
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
