<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidatedAddressType StructType
 * @subpackage Structs
 */
class ValidatedAddressType extends AbstractStructBase
{
    /**
     * The PostalAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StructuredPostalAddressType
     */
    public $PostalAddress;
    /**
     * The AddressLanguage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: msg:AddressLanguage
     * @var string
     */
    public $AddressLanguage;
    /**
     * The score
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $score;
    /**
     * The NumberOfSuffix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfSuffix;
    /**
     * The ServicePointSuffixList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ServicePointSuffixListType
     */
    public $ServicePointSuffixList;
    /**
     * The ServicePointDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ServicePointDetailType
     */
    public $ServicePointDetail;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: msg:Label
     * @var \StructType\LabelType
     */
    public $Label;
    /**
     * The NumberOfBoxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfBoxes;
    /**
     * The ServicePointBoxList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ServicePointBoxListType
     */
    public $ServicePointBoxList;
    /**
     * Constructor method for ValidatedAddressType
     * @uses ValidatedAddressType::setPostalAddress()
     * @uses ValidatedAddressType::setAddressLanguage()
     * @uses ValidatedAddressType::setScore()
     * @uses ValidatedAddressType::setNumberOfSuffix()
     * @uses ValidatedAddressType::setServicePointSuffixList()
     * @uses ValidatedAddressType::setServicePointDetail()
     * @uses ValidatedAddressType::setLabel()
     * @uses ValidatedAddressType::setNumberOfBoxes()
     * @uses ValidatedAddressType::setServicePointBoxList()
     * @param \StructType\StructuredPostalAddressType $postalAddress
     * @param string $addressLanguage
     * @param string $score
     * @param int $numberOfSuffix
     * @param \StructType\ServicePointSuffixListType $servicePointSuffixList
     * @param \StructType\ServicePointDetailType $servicePointDetail
     * @param \StructType\LabelType $label
     * @param int $numberOfBoxes
     * @param \StructType\ServicePointBoxListType $servicePointBoxList
     */
    public function __construct(\StructType\StructuredPostalAddressType $postalAddress = null, $addressLanguage = null, $score = null, $numberOfSuffix = null, \StructType\ServicePointSuffixListType $servicePointSuffixList = null, \StructType\ServicePointDetailType $servicePointDetail = null, \StructType\LabelType $label = null, $numberOfBoxes = null, \StructType\ServicePointBoxListType $servicePointBoxList = null)
    {
        $this
            ->setPostalAddress($postalAddress)
            ->setAddressLanguage($addressLanguage)
            ->setScore($score)
            ->setNumberOfSuffix($numberOfSuffix)
            ->setServicePointSuffixList($servicePointSuffixList)
            ->setServicePointDetail($servicePointDetail)
            ->setLabel($label)
            ->setNumberOfBoxes($numberOfBoxes)
            ->setServicePointBoxList($servicePointBoxList);
    }
    /**
     * Get PostalAddress value
     * @return \StructType\StructuredPostalAddressType|null
     */
    public function getPostalAddress()
    {
        return $this->PostalAddress;
    }
    /**
     * Set PostalAddress value
     * @param \StructType\StructuredPostalAddressType $postalAddress
     * @return \StructType\ValidatedAddressType
     */
    public function setPostalAddress(\StructType\StructuredPostalAddressType $postalAddress = null)
    {
        $this->PostalAddress = $postalAddress;
        return $this;
    }
    /**
     * Get AddressLanguage value
     * @return string|null
     */
    public function getAddressLanguage()
    {
        return $this->AddressLanguage;
    }
    /**
     * Set AddressLanguage value
     * @param string $addressLanguage
     * @return \StructType\ValidatedAddressType
     */
    public function setAddressLanguage($addressLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($addressLanguage) && !is_string($addressLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLanguage)), __LINE__);
        }
        $this->AddressLanguage = $addressLanguage;
        return $this;
    }
    /**
     * Get score value
     * @return string|null
     */
    public function getScore()
    {
        return $this->score;
    }
    /**
     * Set score value
     * @param string $score
     * @return \StructType\ValidatedAddressType
     */
    public function setScore($score = null)
    {
        // validation for constraint: string
        if (!is_null($score) && !is_string($score)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($score)), __LINE__);
        }
        $this->score = $score;
        return $this;
    }
    /**
     * Get NumberOfSuffix value
     * @return int|null
     */
    public function getNumberOfSuffix()
    {
        return $this->NumberOfSuffix;
    }
    /**
     * Set NumberOfSuffix value
     * @param int $numberOfSuffix
     * @return \StructType\ValidatedAddressType
     */
    public function setNumberOfSuffix($numberOfSuffix = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfSuffix) && !is_numeric($numberOfSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfSuffix)), __LINE__);
        }
        $this->NumberOfSuffix = $numberOfSuffix;
        return $this;
    }
    /**
     * Get ServicePointSuffixList value
     * @return \StructType\ServicePointSuffixListType|null
     */
    public function getServicePointSuffixList()
    {
        return $this->ServicePointSuffixList;
    }
    /**
     * Set ServicePointSuffixList value
     * @param \StructType\ServicePointSuffixListType $servicePointSuffixList
     * @return \StructType\ValidatedAddressType
     */
    public function setServicePointSuffixList(\StructType\ServicePointSuffixListType $servicePointSuffixList = null)
    {
        $this->ServicePointSuffixList = $servicePointSuffixList;
        return $this;
    }
    /**
     * Get ServicePointDetail value
     * @return \StructType\ServicePointDetailType|null
     */
    public function getServicePointDetail()
    {
        return $this->ServicePointDetail;
    }
    /**
     * Set ServicePointDetail value
     * @param \StructType\ServicePointDetailType $servicePointDetail
     * @return \StructType\ValidatedAddressType
     */
    public function setServicePointDetail(\StructType\ServicePointDetailType $servicePointDetail = null)
    {
        $this->ServicePointDetail = $servicePointDetail;
        return $this;
    }
    /**
     * Get Label value
     * @return \StructType\LabelType|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * Set Label value
     * @param \StructType\LabelType $label
     * @return \StructType\ValidatedAddressType
     */
    public function setLabel(\StructType\LabelType $label = null)
    {
        $this->Label = $label;
        return $this;
    }
    /**
     * Get NumberOfBoxes value
     * @return int|null
     */
    public function getNumberOfBoxes()
    {
        return $this->NumberOfBoxes;
    }
    /**
     * Set NumberOfBoxes value
     * @param int $numberOfBoxes
     * @return \StructType\ValidatedAddressType
     */
    public function setNumberOfBoxes($numberOfBoxes = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBoxes) && !is_numeric($numberOfBoxes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfBoxes)), __LINE__);
        }
        $this->NumberOfBoxes = $numberOfBoxes;
        return $this;
    }
    /**
     * Get ServicePointBoxList value
     * @return \StructType\ServicePointBoxListType|null
     */
    public function getServicePointBoxList()
    {
        return $this->ServicePointBoxList;
    }
    /**
     * Set ServicePointBoxList value
     * @param \StructType\ServicePointBoxListType $servicePointBoxList
     * @return \StructType\ValidatedAddressType
     */
    public function setServicePointBoxList(\StructType\ServicePointBoxListType $servicePointBoxList = null)
    {
        $this->ServicePointBoxList = $servicePointBoxList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidatedAddressType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
