<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidatedAddressResultType StructType
 * @subpackage Structs
 */
class ValidatedAddressResultType extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The MaileeAndAddressee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MaileeAndAddresseeType
     */
    public $MaileeAndAddressee;
    /**
     * The ValidatedAddressList
     * @var \StructType\ValidatedAddressList
     */
    public $ValidatedAddressList;
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ErrorType[]
     */
    public $Error;
    /**
     * The DetectedInputAddressLanguage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: msg:DetectedInputAddressLanguage
     * @var string
     */
    public $DetectedInputAddressLanguage;
    /**
     * The FormattedSubmittedAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LabelType
     */
    public $FormattedSubmittedAddress;
    /**
     * The TransactionID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: msg:TransactionID
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for ValidatedAddressResultType
     * @uses ValidatedAddressResultType::setId()
     * @uses ValidatedAddressResultType::setMaileeAndAddressee()
     * @uses ValidatedAddressResultType::setValidatedAddressList()
     * @uses ValidatedAddressResultType::setError()
     * @uses ValidatedAddressResultType::setDetectedInputAddressLanguage()
     * @uses ValidatedAddressResultType::setFormattedSubmittedAddress()
     * @uses ValidatedAddressResultType::setTransactionID()
     * @param string $id
     * @param \StructType\MaileeAndAddresseeType $maileeAndAddressee
     * @param \StructType\ValidatedAddressList $validatedAddressList
     * @param \StructType\ErrorType[] $error
     * @param string $detectedInputAddressLanguage
     * @param \StructType\LabelType $formattedSubmittedAddress
     * @param string $transactionID
     */
    public function __construct($id = null, \StructType\MaileeAndAddresseeType $maileeAndAddressee = null, \StructType\ValidatedAddressList $validatedAddressList = null, array $error = array(), $detectedInputAddressLanguage = null, \StructType\LabelType $formattedSubmittedAddress = null, $transactionID = null)
    {
        $this
            ->setId($id)
            ->setMaileeAndAddressee($maileeAndAddressee)
            ->setValidatedAddressList($validatedAddressList)
            ->setError($error)
            ->setDetectedInputAddressLanguage($detectedInputAddressLanguage)
            ->setFormattedSubmittedAddress($formattedSubmittedAddress)
            ->setTransactionID($transactionID);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ValidatedAddressResultType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get MaileeAndAddressee value
     * @return \StructType\MaileeAndAddresseeType|null
     */
    public function getMaileeAndAddressee()
    {
        return $this->MaileeAndAddressee;
    }
    /**
     * Set MaileeAndAddressee value
     * @param \StructType\MaileeAndAddresseeType $maileeAndAddressee
     * @return \StructType\ValidatedAddressResultType
     */
    public function setMaileeAndAddressee(\StructType\MaileeAndAddresseeType $maileeAndAddressee = null)
    {
        $this->MaileeAndAddressee = $maileeAndAddressee;
        return $this;
    }
    /**
     * Get ValidatedAddressList value
     * @return \StructType\ValidatedAddressList|null
     */
    public function getValidatedAddressList()
    {
        return $this->ValidatedAddressList;
    }
    /**
     * Set ValidatedAddressList value
     * @param \StructType\ValidatedAddressList $validatedAddressList
     * @return \StructType\ValidatedAddressResultType
     */
    public function setValidatedAddressList(\StructType\ValidatedAddressList $validatedAddressList = null)
    {
        $this->ValidatedAddressList = $validatedAddressList;
        return $this;
    }
    /**
     * Get Error value
     * @return \StructType\ErrorType[]|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorType[] $error
     * @return \StructType\ValidatedAddressResultType
     */
    public function setError(array $error = array())
    {
        foreach ($error as $validatedAddressResultTypeErrorItem) {
            // validation for constraint: itemType
            if (!$validatedAddressResultTypeErrorItem instanceof \StructType\ErrorType) {
                throw new \InvalidArgumentException(sprintf('The Error property can only contain items of \StructType\ErrorType, "%s" given', is_object($validatedAddressResultTypeErrorItem) ? get_class($validatedAddressResultTypeErrorItem) : gettype($validatedAddressResultTypeErrorItem)), __LINE__);
            }
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Add item to Error value
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorType $item
     * @return \StructType\ValidatedAddressResultType
     */
    public function addToError(\StructType\ErrorType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ErrorType) {
            throw new \InvalidArgumentException(sprintf('The Error property can only contain items of \StructType\ErrorType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Error[] = $item;
        return $this;
    }
    /**
     * Get DetectedInputAddressLanguage value
     * @return string|null
     */
    public function getDetectedInputAddressLanguage()
    {
        return $this->DetectedInputAddressLanguage;
    }
    /**
     * Set DetectedInputAddressLanguage value
     * @param string $detectedInputAddressLanguage
     * @return \StructType\ValidatedAddressResultType
     */
    public function setDetectedInputAddressLanguage($detectedInputAddressLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($detectedInputAddressLanguage) && !is_string($detectedInputAddressLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($detectedInputAddressLanguage)), __LINE__);
        }
        $this->DetectedInputAddressLanguage = $detectedInputAddressLanguage;
        return $this;
    }
    /**
     * Get FormattedSubmittedAddress value
     * @return \StructType\LabelType|null
     */
    public function getFormattedSubmittedAddress()
    {
        return $this->FormattedSubmittedAddress;
    }
    /**
     * Set FormattedSubmittedAddress value
     * @param \StructType\LabelType $formattedSubmittedAddress
     * @return \StructType\ValidatedAddressResultType
     */
    public function setFormattedSubmittedAddress(\StructType\LabelType $formattedSubmittedAddress = null)
    {
        $this->FormattedSubmittedAddress = $formattedSubmittedAddress;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\ValidatedAddressResultType
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidatedAddressResultType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
