<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructuredPostalCodeMunicipalityComplexType StructType
 * @subpackage Structs
 */
class StructuredPostalCodeMunicipalityComplexType extends AbstractStructBase
{
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The MunicipalityName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MunicipalityName;
    /**
     * The DeliveryServiceQualifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryServiceQualifier;
    /**
     * Constructor method for StructuredPostalCodeMunicipalityComplexType
     * @uses StructuredPostalCodeMunicipalityComplexType::setPostalCode()
     * @uses StructuredPostalCodeMunicipalityComplexType::setMunicipalityName()
     * @uses StructuredPostalCodeMunicipalityComplexType::setDeliveryServiceQualifier()
     * @param string $postalCode
     * @param string $municipalityName
     * @param string $deliveryServiceQualifier
     */
    public function __construct($postalCode = null, $municipalityName = null, $deliveryServiceQualifier = null)
    {
        $this
            ->setPostalCode($postalCode)
            ->setMunicipalityName($municipalityName)
            ->setDeliveryServiceQualifier($deliveryServiceQualifier);
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\StructuredPostalCodeMunicipalityComplexType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get MunicipalityName value
     * @return string|null
     */
    public function getMunicipalityName()
    {
        return $this->MunicipalityName;
    }
    /**
     * Set MunicipalityName value
     * @param string $municipalityName
     * @return \StructType\StructuredPostalCodeMunicipalityComplexType
     */
    public function setMunicipalityName($municipalityName = null)
    {
        // validation for constraint: string
        if (!is_null($municipalityName) && !is_string($municipalityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($municipalityName)), __LINE__);
        }
        $this->MunicipalityName = $municipalityName;
        return $this;
    }
    /**
     * Get DeliveryServiceQualifier value
     * @return string|null
     */
    public function getDeliveryServiceQualifier()
    {
        return $this->DeliveryServiceQualifier;
    }
    /**
     * Set DeliveryServiceQualifier value
     * @param string $deliveryServiceQualifier
     * @return \StructType\StructuredPostalCodeMunicipalityComplexType
     */
    public function setDeliveryServiceQualifier($deliveryServiceQualifier = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryServiceQualifier) && !is_string($deliveryServiceQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryServiceQualifier)), __LINE__);
        }
        $this->DeliveryServiceQualifier = $deliveryServiceQualifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StructuredPostalCodeMunicipalityComplexType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
