<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructuredOtherDeliveryInformationComplexType StructType
 * @subpackage Structs
 */
class StructuredOtherDeliveryInformationComplexType extends AbstractStructBase
{
    /**
     * The DeliveryServiceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryServiceType;
    /**
     * The DeliveryServiceIndicator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryServiceIndicator;
    /**
     * Constructor method for StructuredOtherDeliveryInformationComplexType
     * @uses StructuredOtherDeliveryInformationComplexType::setDeliveryServiceType()
     * @uses StructuredOtherDeliveryInformationComplexType::setDeliveryServiceIndicator()
     * @param string $deliveryServiceType
     * @param string $deliveryServiceIndicator
     */
    public function __construct($deliveryServiceType = null, $deliveryServiceIndicator = null)
    {
        $this
            ->setDeliveryServiceType($deliveryServiceType)
            ->setDeliveryServiceIndicator($deliveryServiceIndicator);
    }
    /**
     * Get DeliveryServiceType value
     * @return string|null
     */
    public function getDeliveryServiceType()
    {
        return $this->DeliveryServiceType;
    }
    /**
     * Set DeliveryServiceType value
     * @param string $deliveryServiceType
     * @return \StructType\StructuredOtherDeliveryInformationComplexType
     */
    public function setDeliveryServiceType($deliveryServiceType = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryServiceType) && !is_string($deliveryServiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryServiceType)), __LINE__);
        }
        $this->DeliveryServiceType = $deliveryServiceType;
        return $this;
    }
    /**
     * Get DeliveryServiceIndicator value
     * @return string|null
     */
    public function getDeliveryServiceIndicator()
    {
        return $this->DeliveryServiceIndicator;
    }
    /**
     * Set DeliveryServiceIndicator value
     * @param string $deliveryServiceIndicator
     * @return \StructType\StructuredOtherDeliveryInformationComplexType
     */
    public function setDeliveryServiceIndicator($deliveryServiceIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryServiceIndicator) && !is_string($deliveryServiceIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryServiceIndicator)), __LINE__);
        }
        $this->DeliveryServiceIndicator = $deliveryServiceIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StructuredOtherDeliveryInformationComplexType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
