<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServicePointBoxResultType StructType
 * @subpackage Structs
 */
class ServicePointBoxResultType extends AbstractStructBase
{
    /**
     * The StreetNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StreetNumber;
    /**
     * The BoxNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BoxNumber;
    /**
     * The DeliveryServiceIndicator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryServiceIndicator;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * Constructor method for ServicePointBoxResultType
     * @uses ServicePointBoxResultType::setStreetNumber()
     * @uses ServicePointBoxResultType::setBoxNumber()
     * @uses ServicePointBoxResultType::setDeliveryServiceIndicator()
     * @uses ServicePointBoxResultType::setPostalCode()
     * @param string $streetNumber
     * @param string $boxNumber
     * @param string $deliveryServiceIndicator
     * @param string $postalCode
     */
    public function __construct($streetNumber = null, $boxNumber = null, $deliveryServiceIndicator = null, $postalCode = null)
    {
        $this
            ->setStreetNumber($streetNumber)
            ->setBoxNumber($boxNumber)
            ->setDeliveryServiceIndicator($deliveryServiceIndicator)
            ->setPostalCode($postalCode);
    }
    /**
     * Get StreetNumber value
     * @return string|null
     */
    public function getStreetNumber()
    {
        return $this->StreetNumber;
    }
    /**
     * Set StreetNumber value
     * @param string $streetNumber
     * @return \StructType\ServicePointBoxResultType
     */
    public function setStreetNumber($streetNumber = null)
    {
        // validation for constraint: string
        if (!is_null($streetNumber) && !is_string($streetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetNumber)), __LINE__);
        }
        $this->StreetNumber = $streetNumber;
        return $this;
    }
    /**
     * Get BoxNumber value
     * @return string|null
     */
    public function getBoxNumber()
    {
        return $this->BoxNumber;
    }
    /**
     * Set BoxNumber value
     * @param string $boxNumber
     * @return \StructType\ServicePointBoxResultType
     */
    public function setBoxNumber($boxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($boxNumber) && !is_string($boxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($boxNumber)), __LINE__);
        }
        $this->BoxNumber = $boxNumber;
        return $this;
    }
    /**
     * Get DeliveryServiceIndicator value
     * @return string|null
     */
    public function getDeliveryServiceIndicator()
    {
        return $this->DeliveryServiceIndicator;
    }
    /**
     * Set DeliveryServiceIndicator value
     * @param string $deliveryServiceIndicator
     * @return \StructType\ServicePointBoxResultType
     */
    public function setDeliveryServiceIndicator($deliveryServiceIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryServiceIndicator) && !is_string($deliveryServiceIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryServiceIndicator)), __LINE__);
        }
        $this->DeliveryServiceIndicator = $deliveryServiceIndicator;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\ServicePointBoxResultType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServicePointBoxResultType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
