<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProvideFeedbackResponseType StructType
 * @subpackage Structs
 */
class ProvideFeedbackResponseType extends AbstractStructBase
{
    /**
     * The Result
     * Meta informations extracted from the WSDL
     * - ref: msg:Result
     * @var string
     */
    public $Result;
    /**
     * The GeneralError
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GeneralErrorType
     */
    public $GeneralError;
    /**
     * Constructor method for ProvideFeedbackResponseType
     * @uses ProvideFeedbackResponseType::setResult()
     * @uses ProvideFeedbackResponseType::setGeneralError()
     * @param string $result
     * @param \StructType\GeneralErrorType $generalError
     */
    public function __construct($result = null, \StructType\GeneralErrorType $generalError = null)
    {
        $this
            ->setResult($result)
            ->setGeneralError($generalError);
    }
    /**
     * Get Result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @uses \EnumType\ResultType::valueIsValid()
     * @uses \EnumType\ResultType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $result
     * @return \StructType\ProvideFeedbackResponseType
     */
    public function setResult($result = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ResultType::valueIsValid($result)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $result, implode(', ', \EnumType\ResultType::getValidValues())), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get GeneralError value
     * @return \StructType\GeneralErrorType|null
     */
    public function getGeneralError()
    {
        return $this->GeneralError;
    }
    /**
     * Set GeneralError value
     * @param \StructType\GeneralErrorType $generalError
     * @return \StructType\ProvideFeedbackResponseType
     */
    public function setGeneralError(\StructType\GeneralErrorType $generalError = null)
    {
        $this->GeneralError = $generalError;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProvideFeedbackResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
