<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProvideFeedbackRequestType StructType
 * @subpackage Structs
 */
class ProvideFeedbackRequestType extends AbstractStructBase
{
    /**
     * The TransactionID
     * Meta informations extracted from the WSDL
     * - ref: msg:TransactionID
     * @var string
     */
    public $TransactionID;
    /**
     * The FeedbackDescription
     * @var string
     */
    public $FeedbackDescription;
    /**
     * The CallerIdentification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: msg:CallerIdentification
     * @var \StructType\CallerIdentificationType
     */
    public $CallerIdentification;
    /**
     * Constructor method for ProvideFeedbackRequestType
     * @uses ProvideFeedbackRequestType::setTransactionID()
     * @uses ProvideFeedbackRequestType::setFeedbackDescription()
     * @uses ProvideFeedbackRequestType::setCallerIdentification()
     * @param string $transactionID
     * @param string $feedbackDescription
     * @param \StructType\CallerIdentificationType $callerIdentification
     */
    public function __construct($transactionID = null, $feedbackDescription = null, \StructType\CallerIdentificationType $callerIdentification = null)
    {
        $this
            ->setTransactionID($transactionID)
            ->setFeedbackDescription($feedbackDescription)
            ->setCallerIdentification($callerIdentification);
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\ProvideFeedbackRequestType
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get FeedbackDescription value
     * @return string|null
     */
    public function getFeedbackDescription()
    {
        return $this->FeedbackDescription;
    }
    /**
     * Set FeedbackDescription value
     * @param string $feedbackDescription
     * @return \StructType\ProvideFeedbackRequestType
     */
    public function setFeedbackDescription($feedbackDescription = null)
    {
        // validation for constraint: string
        if (!is_null($feedbackDescription) && !is_string($feedbackDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feedbackDescription)), __LINE__);
        }
        $this->FeedbackDescription = $feedbackDescription;
        return $this;
    }
    /**
     * Get CallerIdentification value
     * @return \StructType\CallerIdentificationType|null
     */
    public function getCallerIdentification()
    {
        return $this->CallerIdentification;
    }
    /**
     * Set CallerIdentification value
     * @param \StructType\CallerIdentificationType $callerIdentification
     * @return \StructType\ProvideFeedbackRequestType
     */
    public function setCallerIdentification(\StructType\CallerIdentificationType $callerIdentification = null)
    {
        $this->CallerIdentification = $callerIdentification;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProvideFeedbackRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
