<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaileeAndAddresseeType StructType
 * @subpackage Structs
 */
class MaileeAndAddresseeType extends AbstractStructBase
{
    /**
     * The AddresseeIndividualIdentification
     * Meta informations extracted from the WSDL
     * - documentation: Mandatory if addressed mail
     * - minOccurs: 0
     * @var \StructType\AddresseeIndividualIdentificationComplexType
     */
    public $AddresseeIndividualIdentification;
    /**
     * The MaileeIndividualIdentification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MaileeIndividualIdentificationComplexType
     */
    public $MaileeIndividualIdentification;
    /**
     * The MaileeOrganizationIdentification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MaileeOrganizationIdentificationComplexType
     */
    public $MaileeOrganizationIdentification;
    /**
     * The MailRecipientDispatchingInformation
     * Meta informations extracted from the WSDL
     * - documentation: Optional, but preferable for Registered mail and Parcels
     * - minOccurs: 0
     * @var \StructType\MailRecipientDispatchingInformationComplexType
     */
    public $MailRecipientDispatchingInformation;
    /**
     * Constructor method for MaileeAndAddresseeType
     * @uses MaileeAndAddresseeType::setAddresseeIndividualIdentification()
     * @uses MaileeAndAddresseeType::setMaileeIndividualIdentification()
     * @uses MaileeAndAddresseeType::setMaileeOrganizationIdentification()
     * @uses MaileeAndAddresseeType::setMailRecipientDispatchingInformation()
     * @param \StructType\AddresseeIndividualIdentificationComplexType $addresseeIndividualIdentification
     * @param \StructType\MaileeIndividualIdentificationComplexType $maileeIndividualIdentification
     * @param \StructType\MaileeOrganizationIdentificationComplexType $maileeOrganizationIdentification
     * @param \StructType\MailRecipientDispatchingInformationComplexType $mailRecipientDispatchingInformation
     */
    public function __construct(\StructType\AddresseeIndividualIdentificationComplexType $addresseeIndividualIdentification = null, \StructType\MaileeIndividualIdentificationComplexType $maileeIndividualIdentification = null, \StructType\MaileeOrganizationIdentificationComplexType $maileeOrganizationIdentification = null, \StructType\MailRecipientDispatchingInformationComplexType $mailRecipientDispatchingInformation = null)
    {
        $this
            ->setAddresseeIndividualIdentification($addresseeIndividualIdentification)
            ->setMaileeIndividualIdentification($maileeIndividualIdentification)
            ->setMaileeOrganizationIdentification($maileeOrganizationIdentification)
            ->setMailRecipientDispatchingInformation($mailRecipientDispatchingInformation);
    }
    /**
     * Get AddresseeIndividualIdentification value
     * @return \StructType\AddresseeIndividualIdentificationComplexType|null
     */
    public function getAddresseeIndividualIdentification()
    {
        return $this->AddresseeIndividualIdentification;
    }
    /**
     * Set AddresseeIndividualIdentification value
     * @param \StructType\AddresseeIndividualIdentificationComplexType $addresseeIndividualIdentification
     * @return \StructType\MaileeAndAddresseeType
     */
    public function setAddresseeIndividualIdentification(\StructType\AddresseeIndividualIdentificationComplexType $addresseeIndividualIdentification = null)
    {
        $this->AddresseeIndividualIdentification = $addresseeIndividualIdentification;
        return $this;
    }
    /**
     * Get MaileeIndividualIdentification value
     * @return \StructType\MaileeIndividualIdentificationComplexType|null
     */
    public function getMaileeIndividualIdentification()
    {
        return $this->MaileeIndividualIdentification;
    }
    /**
     * Set MaileeIndividualIdentification value
     * @param \StructType\MaileeIndividualIdentificationComplexType $maileeIndividualIdentification
     * @return \StructType\MaileeAndAddresseeType
     */
    public function setMaileeIndividualIdentification(\StructType\MaileeIndividualIdentificationComplexType $maileeIndividualIdentification = null)
    {
        $this->MaileeIndividualIdentification = $maileeIndividualIdentification;
        return $this;
    }
    /**
     * Get MaileeOrganizationIdentification value
     * @return \StructType\MaileeOrganizationIdentificationComplexType|null
     */
    public function getMaileeOrganizationIdentification()
    {
        return $this->MaileeOrganizationIdentification;
    }
    /**
     * Set MaileeOrganizationIdentification value
     * @param \StructType\MaileeOrganizationIdentificationComplexType $maileeOrganizationIdentification
     * @return \StructType\MaileeAndAddresseeType
     */
    public function setMaileeOrganizationIdentification(\StructType\MaileeOrganizationIdentificationComplexType $maileeOrganizationIdentification = null)
    {
        $this->MaileeOrganizationIdentification = $maileeOrganizationIdentification;
        return $this;
    }
    /**
     * Get MailRecipientDispatchingInformation value
     * @return \StructType\MailRecipientDispatchingInformationComplexType|null
     */
    public function getMailRecipientDispatchingInformation()
    {
        return $this->MailRecipientDispatchingInformation;
    }
    /**
     * Set MailRecipientDispatchingInformation value
     * @param \StructType\MailRecipientDispatchingInformationComplexType $mailRecipientDispatchingInformation
     * @return \StructType\MaileeAndAddresseeType
     */
    public function setMailRecipientDispatchingInformation(\StructType\MailRecipientDispatchingInformationComplexType $mailRecipientDispatchingInformation = null)
    {
        $this->MailRecipientDispatchingInformation = $mailRecipientDispatchingInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MaileeAndAddresseeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
