<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocalizedStringType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type representing a textual, language-dependent LocalizedString of an element or an entity. The content of this type is typically retrieved from a Master Data Management system that supports multilanguage entities. It is not intended
 * for free-text input purposes.
 * @subpackage Structs
 */
class LocalizedStringType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The locale
     * Meta informations extracted from the WSDL
     * - default: en
     * - use: optional
     * @var string
     */
    public $locale;
    /**
     * Constructor method for LocalizedStringType
     * @uses LocalizedStringType::set_()
     * @uses LocalizedStringType::setLocale()
     * @param string $_
     * @param string $locale
     */
    public function __construct($_ = null, $locale = 'en')
    {
        $this
            ->set_($_)
            ->setLocale($locale);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\LocalizedStringType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->locale;
    }
    /**
     * Set locale value
     * @uses \EnumType\LanguageCodeType::valueIsValid()
     * @uses \EnumType\LanguageCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $locale
     * @return \StructType\LocalizedStringType
     */
    public function setLocale($locale = 'en')
    {
        // validation for constraint: enumeration
        if (!\EnumType\LanguageCodeType::valueIsValid($locale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $locale, implode(', ', \EnumType\LanguageCodeType::getValidValues())), __LINE__);
        }
        $this->locale = $locale;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LocalizedStringType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
