<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorType StructType
 * @subpackage Structs
 */
class ErrorType extends AbstractStructBase
{
    /**
     * The ComponentRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ComponentRef;
    /**
     * The ErrorCode
     * @var string
     */
    public $ErrorCode;
    /**
     * The ErrorSeverity
     * @var string
     */
    public $ErrorSeverity;
    /**
     * Constructor method for ErrorType
     * @uses ErrorType::setComponentRef()
     * @uses ErrorType::setErrorCode()
     * @uses ErrorType::setErrorSeverity()
     * @param string $componentRef
     * @param string $errorCode
     * @param string $errorSeverity
     */
    public function __construct($componentRef = null, $errorCode = null, $errorSeverity = null)
    {
        $this
            ->setComponentRef($componentRef)
            ->setErrorCode($errorCode)
            ->setErrorSeverity($errorSeverity);
    }
    /**
     * Get ComponentRef value
     * @return string|null
     */
    public function getComponentRef()
    {
        return $this->ComponentRef;
    }
    /**
     * Set ComponentRef value
     * @param string $componentRef
     * @return \StructType\ErrorType
     */
    public function setComponentRef($componentRef = null)
    {
        // validation for constraint: string
        if (!is_null($componentRef) && !is_string($componentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($componentRef)), __LINE__);
        }
        $this->ComponentRef = $componentRef;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \StructType\ErrorType
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorSeverity value
     * @return string|null
     */
    public function getErrorSeverity()
    {
        return $this->ErrorSeverity;
    }
    /**
     * Set ErrorSeverity value
     * @param string $errorSeverity
     * @return \StructType\ErrorType
     */
    public function setErrorSeverity($errorSeverity = null)
    {
        // validation for constraint: string
        if (!is_null($errorSeverity) && !is_string($errorSeverity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorSeverity)), __LINE__);
        }
        $this->ErrorSeverity = $errorSeverity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ErrorType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
